/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.slime.Type;

public class EndpointCertificateMetadataSerializer {
    private static final String keyNameField = "keyName";
    private static final String certNameField = "certName";
    private static final String versionField = "version";
    private static final String issuerField = "issuer";

    public static void toSlime(EndpointCertificateMetadata metadata, Cursor object) {
        object.setString(keyNameField, metadata.keyName());
        object.setString(certNameField, metadata.certName());
        object.setLong(versionField, (long)metadata.version());
        object.setString(issuerField, EndpointCertificateMetadataSerializer.serializedValue(metadata.issuer()));
    }

    public static EndpointCertificateMetadata fromSlime(Inspector inspector) {
        if (inspector.type() == Type.OBJECT) {
            return new EndpointCertificateMetadata(inspector.field(keyNameField).asString(), inspector.field(certNameField).asString(), Math.toIntExact(inspector.field(versionField).asLong()), EndpointCertificateMetadataSerializer.providerOf(SlimeUtils.optionalString((Inspector)inspector.field(issuerField)).orElse("")));
        }
        throw new IllegalArgumentException("Unknown format encountered for endpoint certificate metadata!");
    }

    private static EndpointCertificateMetadata.Provider providerOf(String name) {
        return switch (name) {
            case "digicert" -> EndpointCertificateMetadata.Provider.digicert;
            case "globalsign" -> EndpointCertificateMetadata.Provider.globalsign;
            case "zerossl" -> EndpointCertificateMetadata.Provider.zerossl;
            default -> EndpointCertificateMetadata.Provider.digicert;
        };
    }

    private static String serializedValue(EndpointCertificateMetadata.Provider provider) {
        return switch (provider) {
            default -> throw new IncompatibleClassChangeError();
            case EndpointCertificateMetadata.Provider.digicert -> "digicert";
            case EndpointCertificateMetadata.Provider.globalsign -> "globalsign";
            case EndpointCertificateMetadata.Provider.zerossl -> "zerossl";
        };
    }
}

