/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.OnnxModelCost;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.config.server.tenant.SecretStoreExternalIdRetriever;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.PermanentFlags;
import com.yahoo.vespa.flags.StringFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import java.io.File;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final ExecutorService executor;
    private final HostProvisioner hostProvisioner;
    private final Provisioned provisioned;
    private final Optional<? extends Reindexing> reindexing;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final OnnxModelCost onnxModelCost;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, ExecutorService executor, Optional<? extends Reindexing> reindexing, HostProvisioner hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, OnnxModelCost onnxModelCost, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.executor = executor;
        this.reindexing = reindexing;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
        this.onnxModelCost = onnxModelCost;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public HostProvisioner getHostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Optional<? extends Reindexing> reindexing() {
        return this.reindexing;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public OnnxModelCost onnxModelCost() {
        return this.onnxModelCost;
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    private static <V> V flagValue(FlagSource source, ApplicationId appId, UnboundFlag<? extends V, ?, ?> flag) {
        return (V)((Flag)((Flag)flag.bindTo(source).with(Dimension.INSTANCE_ID, appId.serializedForm())).with(Dimension.APPLICATION, appId.toSerializedFormWithoutInstance())).boxedValue();
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ModelContext.FeatureFlags featureFlags;
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final Optional<AthenzDomain> athenzDomain;
        private final Quota quota;
        private final List<TenantSecretStore> tenantSecretStores;
        private final SecretStore secretStore;
        private final StringFlag jvmGCOptionsFlag;
        private final boolean allowDisableMtls;
        private final List<X509Certificate> operatorCertificates;
        private final List<String> tlsCiphersOverride;
        private final List<String> zoneDnsSuffixes;
        private final List<String> environmentVariables;
        private final Optional<CloudAccount> cloudAccount;
        private final List<DataplaneToken> dataplaneTokens;
        private final boolean allowUserFilters;
        private final Duration endpointConnectionTtl;

        public Properties(ApplicationId applicationId, Version modelVersion, ConfigserverConfig configserverConfig, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain, Optional<Quota> maybeQuota, List<TenantSecretStore> tenantSecretStores, SecretStore secretStore, List<X509Certificate> operatorCertificates, Optional<CloudAccount> cloudAccount, List<DataplaneToken> dataplaneTokens) {
            this.featureFlags = new FeatureFlags(flagSource, applicationId, modelVersion);
            this.applicationId = applicationId;
            this.multitenant = configserverConfig.multitenant() || configserverConfig.hostedVespa() || Boolean.getBoolean("multitenant");
            this.configServerSpecs = ConfigServerSpec.fromConfig(configserverConfig);
            this.loadBalancerName = configserverConfig.loadBalancerAddress().isEmpty() ? null : HostName.of((String)configserverConfig.loadBalancerAddress());
            this.ztsUrl = configserverConfig.ztsUrl() != null ? URI.create(configserverConfig.ztsUrl()) : null;
            this.athenzDnsSuffix = configserverConfig.athenzDnsSuffix();
            this.hostedVespa = configserverConfig.hostedVespa();
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.athenzDomain = athenzDomain;
            this.quota = maybeQuota.orElseGet(Quota::unlimited);
            this.tenantSecretStores = tenantSecretStores;
            this.secretStore = secretStore;
            this.jvmGCOptionsFlag = (StringFlag)((StringFlag)((StringFlag)PermanentFlags.JVM_GC_OPTIONS.bindTo(flagSource)).with(Dimension.INSTANCE_ID, applicationId.serializedForm())).with(Dimension.APPLICATION, applicationId.toSerializedFormWithoutInstance());
            this.allowDisableMtls = (Boolean)ModelContextImpl.flagValue(flagSource, applicationId, PermanentFlags.ALLOW_DISABLE_MTLS);
            this.operatorCertificates = operatorCertificates;
            this.tlsCiphersOverride = (List)ModelContextImpl.flagValue(flagSource, applicationId, PermanentFlags.TLS_CIPHERS_OVERRIDE);
            this.zoneDnsSuffixes = configserverConfig.zoneDnsSuffixes();
            this.environmentVariables = (List)ModelContextImpl.flagValue(flagSource, applicationId, PermanentFlags.ENVIRONMENT_VARIABLES);
            this.cloudAccount = cloudAccount;
            this.allowUserFilters = (Boolean)ModelContextImpl.flagValue(flagSource, applicationId, PermanentFlags.ALLOW_USER_FILTERS);
            this.endpointConnectionTtl = Duration.ofSeconds(((Integer)ModelContextImpl.flagValue(flagSource, applicationId, PermanentFlags.ENDPOINT_CONNECTION_TTL)).intValue());
            this.dataplaneTokens = dataplaneTokens;
        }

        public ModelContext.FeatureFlags featureFlags() {
            return this.featureFlags;
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }

        public Quota quota() {
            return this.quota;
        }

        public List<TenantSecretStore> tenantSecretStores() {
            return SecretStoreExternalIdRetriever.populateExternalId(this.secretStore, this.applicationId.tenant(), this.zone.system(), this.tenantSecretStores);
        }

        public String jvmGCOptions(Optional<ClusterSpec.Type> clusterType) {
            return this.flagValueForClusterType(this.jvmGCOptionsFlag, clusterType);
        }

        public boolean allowDisableMtls() {
            return this.allowDisableMtls;
        }

        public List<X509Certificate> operatorCertificates() {
            return this.operatorCertificates;
        }

        public List<String> tlsCiphersOverride() {
            return this.tlsCiphersOverride;
        }

        public List<String> zoneDnsSuffixes() {
            return this.zoneDnsSuffixes;
        }

        public String flagValueForClusterType(StringFlag flag, Optional<ClusterSpec.Type> clusterType) {
            return clusterType.map(type -> (StringFlag)flag.with(Dimension.CLUSTER_TYPE, type.name())).orElse(flag).value();
        }

        public List<String> environmentVariables() {
            return this.environmentVariables;
        }

        public Optional<CloudAccount> cloudAccount() {
            return this.cloudAccount;
        }

        public List<DataplaneToken> dataplaneTokens() {
            return this.dataplaneTokens;
        }

        public boolean allowUserFilters() {
            return this.allowUserFilters;
        }

        public Duration endpointConnectionTtl() {
            return this.endpointConnectionTtl;
        }
    }

    public static class FeatureFlags
    implements ModelContext.FeatureFlags {
        private final String queryDispatchPolicy;
        private final double queryDispatchWarmup;
        private final double defaultTermwiseLimit;
        private final String feedSequencer;
        private final String responseSequencer;
        private final int numResponseThreads;
        private final boolean useAsyncMessageHandlingOnSchedule;
        private final double feedConcurrency;
        private final double feedNiceness;
        private final List<String> allowedAthenzProxyIdentities;
        private final int maxActivationInhibitedOutOfSyncGroups;
        private final Predicate<ClusterSpec.Type> jvmOmitStackTraceInFastThrow;
        private final double resourceLimitDisk;
        private final double resourceLimitMemory;
        private final double minNodeRatioPerGroup;
        private final boolean containerDumpHeapOnShutdownTimeout;
        private final boolean loadCodeAsHugePages;
        private final double containerShutdownTimeout;
        private final int maxUnCommittedMemory;
        private final boolean forwardIssuesAsErrors;
        private final boolean useV8GeoPositions;
        private final int maxCompactBuffers;
        private final List<String> ignoredHttpUserAgents;
        private final boolean enableProxyProtocolMixedMode;
        private final boolean sharedStringRepoNoReclaim;
        private final String logFileCompressionAlgorithm;
        private final int mbus_network_threads;
        private final int mbus_java_num_targets;
        private final int mbus_java_events_before_wakeup;
        private final int mbus_cpp_num_targets;
        private final int mbus_cpp_events_before_wakeup;
        private final int rpc_num_targets;
        private final int rpc_events_before_wakeup;
        private final int heapPercentage;
        private final String summaryDecodePolicy;
        private boolean sortBlueprintsByCost;
        private final boolean alwaysMarkPhraseExpensive;
        private final int contentLayerMetadataFeatureLevel;
        private final boolean dynamicHeapSize;
        private final String unknownConfigDefinition;
        private final int searchHandlerThreadpool;
        private final long mergingMaxMemoryUsagePerNode;
        private final boolean usePerDocumentThrottledDeleteBucket;
        private final boolean restartOnDeployWhenOnnxModelChanges;

        public FeatureFlags(FlagSource source, ApplicationId appId, Version version) {
            this.defaultTermwiseLimit = (Double)FeatureFlags.flagValue(source, appId, version, Flags.DEFAULT_TERM_WISE_LIMIT);
            this.feedSequencer = (String)FeatureFlags.flagValue(source, appId, version, Flags.FEED_SEQUENCER_TYPE);
            this.responseSequencer = (String)FeatureFlags.flagValue(source, appId, version, Flags.RESPONSE_SEQUENCER_TYPE);
            this.numResponseThreads = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.RESPONSE_NUM_THREADS);
            this.useAsyncMessageHandlingOnSchedule = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE);
            this.feedConcurrency = (Double)FeatureFlags.flagValue(source, appId, version, Flags.FEED_CONCURRENCY);
            this.feedNiceness = (Double)FeatureFlags.flagValue(source, appId, version, Flags.FEED_NICENESS);
            this.mbus_network_threads = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_NUM_NETWORK_THREADS);
            this.allowedAthenzProxyIdentities = (List)FeatureFlags.flagValue(source, appId, version, Flags.ALLOWED_ATHENZ_PROXY_IDENTITIES);
            this.maxActivationInhibitedOutOfSyncGroups = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS);
            this.jvmOmitStackTraceInFastThrow = type -> (Boolean)FeatureFlags.flagValue(source, appId, version, type, PermanentFlags.JVM_OMIT_STACK_TRACE_IN_FAST_THROW);
            this.resourceLimitDisk = (Double)FeatureFlags.flagValue(source, appId, version, PermanentFlags.RESOURCE_LIMIT_DISK);
            this.resourceLimitMemory = (Double)FeatureFlags.flagValue(source, appId, version, PermanentFlags.RESOURCE_LIMIT_MEMORY);
            this.minNodeRatioPerGroup = (Double)FeatureFlags.flagValue(source, appId, version, Flags.MIN_NODE_RATIO_PER_GROUP);
            this.containerDumpHeapOnShutdownTimeout = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT);
            this.loadCodeAsHugePages = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.LOAD_CODE_AS_HUGEPAGES);
            this.containerShutdownTimeout = (Double)FeatureFlags.flagValue(source, appId, version, Flags.CONTAINER_SHUTDOWN_TIMEOUT);
            this.maxUnCommittedMemory = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_UNCOMMITTED_MEMORY);
            this.forwardIssuesAsErrors = (Boolean)FeatureFlags.flagValue(source, appId, version, PermanentFlags.FORWARD_ISSUES_AS_ERRORS);
            this.useV8GeoPositions = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_V8_GEO_POSITIONS);
            this.maxCompactBuffers = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MAX_COMPACT_BUFFERS);
            this.ignoredHttpUserAgents = (List)FeatureFlags.flagValue(source, appId, version, PermanentFlags.IGNORED_HTTP_USER_AGENTS);
            this.enableProxyProtocolMixedMode = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.ENABLE_PROXY_PROTOCOL_MIXED_MODE);
            this.sharedStringRepoNoReclaim = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.SHARED_STRING_REPO_NO_RECLAIM);
            this.logFileCompressionAlgorithm = (String)FeatureFlags.flagValue(source, appId, version, Flags.LOG_FILE_COMPRESSION_ALGORITHM);
            this.mbus_java_num_targets = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_JAVA_NUM_TARGETS);
            this.mbus_java_events_before_wakeup = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_JAVA_EVENTS_BEFORE_WAKEUP);
            this.mbus_cpp_num_targets = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_CPP_NUM_TARGETS);
            this.mbus_cpp_events_before_wakeup = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.MBUS_CPP_EVENTS_BEFORE_WAKEUP);
            this.rpc_num_targets = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.RPC_NUM_TARGETS);
            this.rpc_events_before_wakeup = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.RPC_EVENTS_BEFORE_WAKEUP);
            this.queryDispatchPolicy = (String)FeatureFlags.flagValue(source, appId, version, Flags.QUERY_DISPATCH_POLICY);
            this.queryDispatchWarmup = (Double)FeatureFlags.flagValue(source, appId, version, PermanentFlags.QUERY_DISPATCH_WARMUP);
            this.heapPercentage = (Integer)FeatureFlags.flagValue(source, appId, version, PermanentFlags.HEAP_SIZE_PERCENTAGE);
            this.summaryDecodePolicy = (String)FeatureFlags.flagValue(source, appId, version, Flags.SUMMARY_DECODE_POLICY);
            this.contentLayerMetadataFeatureLevel = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.CONTENT_LAYER_METADATA_FEATURE_LEVEL);
            this.dynamicHeapSize = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.DYNAMIC_HEAP_SIZE);
            this.unknownConfigDefinition = (String)FeatureFlags.flagValue(source, appId, version, Flags.UNKNOWN_CONFIG_DEFINITION);
            this.searchHandlerThreadpool = (Integer)FeatureFlags.flagValue(source, appId, version, Flags.SEARCH_HANDLER_THREADPOOL);
            this.mergingMaxMemoryUsagePerNode = (Long)FeatureFlags.flagValue(source, appId, version, Flags.MERGING_MAX_MEMORY_USAGE_PER_NODE);
            this.usePerDocumentThrottledDeleteBucket = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.USE_PER_DOCUMENT_THROTTLED_DELETE_BUCKET);
            this.alwaysMarkPhraseExpensive = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.ALWAYS_MARK_PHRASE_EXPENSIVE);
            this.restartOnDeployWhenOnnxModelChanges = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.RESTART_ON_DEPLOY_WHEN_ONNX_MODEL_CHANGES);
            this.sortBlueprintsByCost = (Boolean)FeatureFlags.flagValue(source, appId, version, Flags.SORT_BLUEPRINTS_BY_COST);
        }

        public int heapSizePercentage() {
            return this.heapPercentage;
        }

        public String queryDispatchPolicy() {
            return this.queryDispatchPolicy;
        }

        public double queryDispatchWarmup() {
            return this.queryDispatchWarmup;
        }

        public String summaryDecodePolicy() {
            return this.summaryDecodePolicy;
        }

        public double defaultTermwiseLimit() {
            return this.defaultTermwiseLimit;
        }

        public String feedSequencerType() {
            return this.feedSequencer;
        }

        public String responseSequencerType() {
            return this.responseSequencer;
        }

        public int defaultNumResponseThreads() {
            return this.numResponseThreads;
        }

        public boolean useAsyncMessageHandlingOnSchedule() {
            return this.useAsyncMessageHandlingOnSchedule;
        }

        public double feedConcurrency() {
            return this.feedConcurrency;
        }

        public double feedNiceness() {
            return this.feedNiceness;
        }

        public int mbusNetworkThreads() {
            return this.mbus_network_threads;
        }

        public List<String> allowedAthenzProxyIdentities() {
            return this.allowedAthenzProxyIdentities;
        }

        public int maxActivationInhibitedOutOfSyncGroups() {
            return this.maxActivationInhibitedOutOfSyncGroups;
        }

        public String jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type type) {
            return this.translateJvmOmitStackTraceInFastThrowToString(this.jvmOmitStackTraceInFastThrow, type);
        }

        public double resourceLimitDisk() {
            return this.resourceLimitDisk;
        }

        public double resourceLimitMemory() {
            return this.resourceLimitMemory;
        }

        public double minNodeRatioPerGroup() {
            return this.minNodeRatioPerGroup;
        }

        public double containerShutdownTimeout() {
            return this.containerShutdownTimeout;
        }

        public boolean containerDumpHeapOnShutdownTimeout() {
            return this.containerDumpHeapOnShutdownTimeout;
        }

        public boolean loadCodeAsHugePages() {
            return this.loadCodeAsHugePages;
        }

        public int maxUnCommittedMemory() {
            return this.maxUnCommittedMemory;
        }

        public boolean forwardIssuesAsErrors() {
            return this.forwardIssuesAsErrors;
        }

        public boolean useV8GeoPositions() {
            return this.useV8GeoPositions;
        }

        public int maxCompactBuffers() {
            return this.maxCompactBuffers;
        }

        public List<String> ignoredHttpUserAgents() {
            return this.ignoredHttpUserAgents;
        }

        public boolean enableProxyProtocolMixedMode() {
            return this.enableProxyProtocolMixedMode;
        }

        public boolean sharedStringRepoNoReclaim() {
            return this.sharedStringRepoNoReclaim;
        }

        public int mbusJavaRpcNumTargets() {
            return this.mbus_java_num_targets;
        }

        public int mbusJavaEventsBeforeWakeup() {
            return this.mbus_java_events_before_wakeup;
        }

        public int mbusCppRpcNumTargets() {
            return this.mbus_cpp_num_targets;
        }

        public int mbusCppEventsBeforeWakeup() {
            return this.mbus_cpp_events_before_wakeup;
        }

        public int rpcNumTargets() {
            return this.rpc_num_targets;
        }

        public int rpcEventsBeforeWakeup() {
            return this.rpc_events_before_wakeup;
        }

        public String logFileCompressionAlgorithm(String defVal) {
            String fflag = this.logFileCompressionAlgorithm;
            if (fflag != null && !fflag.isEmpty()) {
                return fflag;
            }
            return defVal;
        }

        public boolean alwaysMarkPhraseExpensive() {
            return this.alwaysMarkPhraseExpensive;
        }

        public int contentLayerMetadataFeatureLevel() {
            return this.contentLayerMetadataFeatureLevel;
        }

        public boolean dynamicHeapSize() {
            return this.dynamicHeapSize;
        }

        public String unknownConfigDefinition() {
            return this.unknownConfigDefinition;
        }

        public int searchHandlerThreadpool() {
            return this.searchHandlerThreadpool;
        }

        public long mergingMaxMemoryUsagePerNode() {
            return this.mergingMaxMemoryUsagePerNode;
        }

        public boolean usePerDocumentThrottledDeleteBucket() {
            return this.usePerDocumentThrottledDeleteBucket;
        }

        public boolean restartOnDeployWhenOnnxModelChanges() {
            return this.restartOnDeployWhenOnnxModelChanges;
        }

        public boolean sortBlueprintsByCost() {
            return this.sortBlueprintsByCost;
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, Version vespaVersion, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)((Flag)((Flag)flag.bindTo(source).with(Dimension.INSTANCE_ID, appId.serializedForm())).with(Dimension.APPLICATION, appId.toSerializedFormWithoutInstance())).with(Dimension.VESPA_VERSION, vespaVersion.toFullString())).with(Dimension.TENANT_ID, appId.tenant().value())).boxedValue();
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, Version vespaVersion, ClusterSpec.Type clusterType, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)((Flag)((Flag)flag.bindTo(source).with(Dimension.INSTANCE_ID, appId.serializedForm())).with(Dimension.APPLICATION, appId.toSerializedFormWithoutInstance())).with(Dimension.CLUSTER_TYPE, clusterType.name())).with(Dimension.VESPA_VERSION, vespaVersion.toFullString())).boxedValue();
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, Version vespaVersion, ClusterSpec.Id clusterId, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)((Flag)((Flag)((Flag)flag.bindTo(source).with(Dimension.INSTANCE_ID, appId.serializedForm())).with(Dimension.APPLICATION, appId.toSerializedFormWithoutInstance())).with(Dimension.CLUSTER_ID, clusterId.value())).with(Dimension.VESPA_VERSION, vespaVersion.toFullString())).boxedValue();
        }

        private String translateJvmOmitStackTraceInFastThrowToString(Predicate<ClusterSpec.Type> function, ClusterSpec.Type clusterType) {
            return function.test(clusterType) ? "" : "-XX:-OmitStackTraceInFastThrow";
        }
    }
}

