/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import java.util.List;

public class SecretStoreExternalIdRetriever {
    private static final String SECRET_NAME_FORMAT = "%s.external.id.%s.%s";

    public static List<TenantSecretStore> populateExternalId(SecretStore secretStore, TenantName tenant, SystemName system, List<TenantSecretStore> tenantSecretStores) {
        return tenantSecretStores.stream().map(tenantSecretStore -> {
            String secretName = SecretStoreExternalIdRetriever.secretName(tenant, system, tenantSecretStore.getName());
            String secret = secretStore.getSecret(secretName);
            if (secret == null) {
                throw new RuntimeException("No secret found in secret store for " + secretName);
            }
            return tenantSecretStore.withExternalId(secret);
        }).toList();
    }

    public static String secretName(TenantName tenant, SystemName system, String storeName) {
        return String.format(SECRET_NAME_FORMAT, SecretStoreExternalIdRetriever.tenantSecretGroup(system), tenant.value(), storeName);
    }

    private static String tenantSecretGroup(SystemName system) {
        switch (system) {
            case Public: {
                return "vespa.external.tenant.secrets";
            }
            case PublicCd: {
                return "vespa.external.cd.tenant.secrets";
            }
        }
        throw new IllegalArgumentException("No tenant secret store key group defined for system " + system);
    }
}

