/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import java.util.Objects;
import java.util.Optional;

public class RemoteSession
extends Session {
    private final Optional<ApplicationVersions> applicationVersions;

    RemoteSession(TenantName tenant, long sessionId, SessionZooKeeperClient zooKeeperClient) {
        this(tenant, sessionId, zooKeeperClient, Optional.empty());
    }

    RemoteSession(TenantName tenant, long sessionId, SessionZooKeeperClient zooKeeperClient, Optional<ApplicationVersions> applicationSet) {
        super(tenant, sessionId, zooKeeperClient);
        this.applicationVersions = applicationSet;
    }

    @Override
    public Optional<ApplicationVersions> applicationVersions() {
        return this.applicationVersions;
    }

    public synchronized RemoteSession activated(ApplicationVersions applicationVersions) {
        Objects.requireNonNull(applicationVersions, "applicationVersions cannot be null");
        return new RemoteSession(this.tenant, this.sessionId, this.sessionZooKeeperClient, Optional.of(applicationVersions));
    }

    public synchronized RemoteSession deactivated() {
        return new RemoteSession(this.tenant, this.sessionId, this.sessionZooKeeperClient, Optional.empty());
    }

    @Override
    public String toString() {
        return super.toString() + ", application versions=" + this.applicationVersions;
    }
}

