/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ApplicationPackageMaintainer;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.ReindexingMaintainer;
import com.yahoo.vespa.config.server.maintenance.SessionsMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.curator.Curator;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConfigServerMaintenance {
    private final List<Maintainer> maintainers = new CopyOnWriteArrayList<Maintainer>();
    private final ApplicationRepository applicationRepository;
    private final Curator curator;
    private final ConfigConvergenceChecker convergenceChecker;
    private final FileDirectory fileDirectory;
    private final Duration interval;

    public ConfigServerMaintenance(ApplicationRepository applicationRepository, FileDirectory fileDirectory) {
        this.applicationRepository = applicationRepository;
        this.curator = applicationRepository.tenantRepository().getCurator();
        this.convergenceChecker = applicationRepository.configConvergenceChecker();
        this.fileDirectory = fileDirectory;
        this.interval = Duration.ofMinutes(applicationRepository.configserverConfig().maintainerIntervalMinutes());
    }

    public void startBeforeBootstrap() {
        if (this.moreThanOneConfigServer()) {
            this.maintainers.add(new ApplicationPackageMaintainer(this.applicationRepository, this.curator, Duration.ofSeconds(15L)));
        }
        this.maintainers.add(new TenantsMaintainer(this.applicationRepository, this.curator, this.interval, Clock.systemUTC()));
    }

    public void startAfterBootstrap() {
        this.maintainers.add(new FileDistributionMaintainer(this.applicationRepository, this.curator, this.interval, this.fileDirectory));
        this.maintainers.add(new SessionsMaintainer(this.applicationRepository, this.curator, Duration.ofSeconds(30L)));
        this.maintainers.add(new ReindexingMaintainer(this.applicationRepository, this.curator, Duration.ofMinutes(3L), this.convergenceChecker, Clock.systemUTC()));
    }

    public void shutdown() {
        this.maintainers.forEach(Maintainer::shutdown);
        this.maintainers.forEach(Maintainer::awaitShutdown);
    }

    public List<Maintainer> maintainers() {
        return List.copyOf(this.maintainers);
    }

    private boolean moreThanOneConfigServer() {
        return !FileDistributionUtil.getOtherConfigServersInCluster(this.applicationRepository.configserverConfig()).isEmpty();
    }
}

