/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Clock;
import java.time.Duration;
import java.util.Set;
import java.util.logging.Level;

public class TenantsMaintainer
extends ConfigServerMaintainer {
    static final Duration defaultTtlForUnusedTenant = Duration.ofDays(7L);
    private final Duration ttlForUnusedTenant = defaultTtlForUnusedTenant;
    private final Clock clock;

    TenantsMaintainer(ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, Duration interval, Clock clock) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock(), interval, true);
        this.clock = clock;
    }

    protected double maintain() {
        if (!this.applicationRepository.configserverConfig().hostedVespa()) {
            return 1.0;
        }
        Set<TenantName> tenants = this.applicationRepository.deleteUnusedTenants(this.ttlForUnusedTenant, this.clock.instant());
        if (tenants.size() > 0) {
            this.log.log(Level.INFO, "Deleted tenants " + tenants);
        }
        return 1.0;
    }
}

