/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.Type;
import java.util.ArrayList;
import java.util.List;

public class TenantSecretStoreSerializer {
    private static final String awsIdField = "awsId";
    private static final String roleField = "role";
    private static final String nameField = "name";

    public static Slime toSlime(List<TenantSecretStore> tenantSecretStores) {
        Slime slime = new Slime();
        Cursor cursor = slime.setArray();
        TenantSecretStoreSerializer.toSlime(tenantSecretStores, cursor);
        return slime;
    }

    public static void toSlime(List<TenantSecretStore> tenantSecretStores, Cursor cursor) {
        tenantSecretStores.forEach(tenantSecretStore -> TenantSecretStoreSerializer.toSlime(tenantSecretStore, cursor.addObject()));
    }

    public static void toSlime(TenantSecretStore tenantSecretStore, Cursor object) {
        object.setString(awsIdField, tenantSecretStore.getAwsId());
        object.setString(nameField, tenantSecretStore.getName());
        object.setString(roleField, tenantSecretStore.getRole());
    }

    public static TenantSecretStore fromSlime(Inspector inspector) {
        if (inspector.type() == Type.OBJECT) {
            return new TenantSecretStore(inspector.field(nameField).asString(), inspector.field(awsIdField).asString(), inspector.field(roleField).asString());
        }
        throw new IllegalArgumentException("Unknown format encountered for endpoint certificate metadata!");
    }

    public static List<TenantSecretStore> listFromSlime(Inspector inspector) {
        ArrayList<TenantSecretStore> tenantSecretStores = new ArrayList<TenantSecretStore>();
        inspector.traverse((idx, store) -> tenantSecretStores.add(TenantSecretStoreSerializer.fromSlime(store)));
        return tenantSecretStores;
    }
}

