/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.model;

import com.yahoo.cloud.config.LbServicesConfig;
import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ApplicationClusterInfo;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.flags.FlagSource;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class LbServicesProducer
implements LbServicesConfig.Producer {
    private final Map<TenantName, Set<ApplicationInfo>> models;
    private final Zone zone;

    public LbServicesProducer(Map<TenantName, Set<ApplicationInfo>> models, Zone zone, FlagSource flagSource) {
        this.models = models;
        this.zone = zone;
    }

    public void getConfig(LbServicesConfig.Builder builder) {
        this.models.keySet().stream().sorted().forEach(tenant -> builder.tenants(tenant.value(), this.getTenantConfig(this.models.get(tenant))));
    }

    private LbServicesConfig.Tenants.Builder getTenantConfig(Set<ApplicationInfo> apps) {
        LbServicesConfig.Tenants.Builder tb = new LbServicesConfig.Tenants.Builder();
        apps.stream().sorted(Comparator.comparing(ApplicationInfo::getApplicationId)).filter(applicationInfo -> this.generateRoutingConfig(applicationInfo.getApplicationId())).forEach(applicationInfo -> tb.applications(this.createLbAppIdKey(applicationInfo.getApplicationId()), this.getAppConfig((ApplicationInfo)applicationInfo)));
        return tb;
    }

    private boolean generateRoutingConfig(ApplicationId applicationId) {
        return !applicationId.instance().isTester();
    }

    private String createLbAppIdKey(ApplicationId applicationId) {
        return applicationId.application().value() + ":" + this.zone.environment().value() + ":" + this.zone.region().value() + ":" + applicationId.instance().value();
    }

    private LbServicesConfig.Tenants.Applications.Builder getAppConfig(ApplicationInfo app) {
        LbServicesConfig.Tenants.Applications.Builder ab = new LbServicesConfig.Tenants.Applications.Builder();
        ab.activeRotation(this.getActiveRotation(app));
        Set applicationClusterInfos = app.getModel().applicationClusterInfo();
        List endpointBuilder = applicationClusterInfos.stream().sorted(Comparator.comparing(ApplicationClusterInfo::name)).map(ApplicationClusterInfo::endpoints).flatMap(endpoints -> this.getEndpointConfig((List<ApplicationClusterEndpoint>)endpoints).stream()).toList();
        ab.endpoints(endpointBuilder);
        return ab;
    }

    private List<LbServicesConfig.Tenants.Applications.Endpoints.Builder> getEndpointConfig(List<ApplicationClusterEndpoint> clusterEndpoints) {
        return clusterEndpoints.stream().sorted(Comparator.comparing(ApplicationClusterEndpoint::dnsName)).map(this::getEndpointConfig).toList();
    }

    private LbServicesConfig.Tenants.Applications.Endpoints.Builder getEndpointConfig(ApplicationClusterEndpoint clusterEndpoints) {
        LbServicesConfig.Tenants.Applications.Endpoints.Builder builder = new LbServicesConfig.Tenants.Applications.Endpoints.Builder();
        return builder.dnsName(clusterEndpoints.dnsName().value()).scope(LbServicesConfig.Tenants.Applications.Endpoints.Scope.Enum.valueOf((String)clusterEndpoints.scope().name())).routingMethod(LbServicesConfig.Tenants.Applications.Endpoints.RoutingMethod.Enum.valueOf((String)clusterEndpoints.routingMethod().name())).weight(clusterEndpoints.weight()).hosts((Collection)clusterEndpoints.hostNames()).clusterId(clusterEndpoints.clusterId());
    }

    private boolean getActiveRotation(ApplicationInfo app) {
        boolean activeRotation = false;
        for (HostInfo hostInfo : app.getModel().getHosts()) {
            Optional<ServiceInfo> container = hostInfo.getServices().stream().filter(serviceInfo -> serviceInfo.getServiceType().equals(ContainerServiceType.CONTAINER.serviceName) || serviceInfo.getServiceType().equals(ContainerServiceType.QRSERVER.serviceName)).findAny();
            if (!container.isPresent()) continue;
            activeRotation |= Boolean.parseBoolean(container.get().getProperty("activeRotation").orElse("false"));
        }
        return activeRotation;
    }
}

