/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.v2.response.DeploymentMetricsResponse;
import com.yahoo.vespa.config.server.metrics.ClusterDeploymentMetricsRetriever;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.DeploymentMetricsAggregator;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class DeploymentMetricsRetriever {
    private final ClusterDeploymentMetricsRetriever metricsRetriever;

    public DeploymentMetricsRetriever() {
        this(new ClusterDeploymentMetricsRetriever());
    }

    public DeploymentMetricsRetriever(ClusterDeploymentMetricsRetriever metricsRetriever) {
        this.metricsRetriever = metricsRetriever;
    }

    public DeploymentMetricsResponse getMetrics(Application application) {
        Collection<URI> hosts = DeploymentMetricsRetriever.getHostsOfApplication(application);
        Map<ClusterInfo, DeploymentMetricsAggregator> clusterMetrics = this.metricsRetriever.requestMetricsGroupedByCluster(hosts);
        return new DeploymentMetricsResponse(application.getId(), clusterMetrics);
    }

    private static Collection<URI> getHostsOfApplication(Application application) {
        return application.getModel().getHosts().stream().filter(host -> host.getServices().stream().noneMatch(DeploymentMetricsRetriever.isLogserver())).map(HostInfo::getHostname).map(DeploymentMetricsRetriever::createMetricsProxyURI).toList();
    }

    private static Predicate<ServiceInfo> isLogserver() {
        return serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("logserver");
    }

    private static URI createMetricsProxyURI(String hostname) {
        return URI.create("http://" + hostname + ":19092/metrics/v1/values?consumer=Vespa");
    }
}

