/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2.request;

import ai.vespa.http.HttpURL;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.vespa.config.server.http.ContentRequest;

public class ApplicationContentRequest
extends ContentRequest {
    private final ApplicationId applicationId;
    private final Zone zone;

    public ApplicationContentRequest(HttpRequest request, long sessionId, ApplicationId applicationId, Zone zone, HttpURL.Path contentPath, ApplicationFile applicationFile) {
        super(request, sessionId, contentPath, applicationFile);
        this.applicationId = applicationId;
        this.zone = zone;
    }

    @Override
    public String getPathPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append("/application/v2/tenant/").append(this.applicationId.tenant().value());
        sb.append("/application/").append(this.applicationId.application().value());
        sb.append("/environment/").append(this.zone.environment().value());
        sb.append("/region/").append(this.zone.region().value());
        sb.append("/instance/").append(this.applicationId.instance().value());
        return sb.toString();
    }
}

