/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.container.jdisc.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SessionContentReadResponse
extends HttpResponse {
    private static final Map<String, String> contentTypeByExtension = SessionContentReadResponse.loadContentTypeByExtension();
    private final ApplicationFile file;

    public SessionContentReadResponse(ApplicationFile file) {
        super(200);
        this.file = file;
    }

    public void render(OutputStream outputStream) throws IOException {
        try (InputStream inputStream = this.file.createInputStream();){
            inputStream.transferTo(outputStream);
        }
    }

    public String getContentType() {
        String contentType;
        String filename = this.file.getPath().getName();
        int lastDotIndex = filename.lastIndexOf(46);
        if (lastDotIndex >= 0 && (contentType = contentTypeByExtension.get(filename.substring(lastDotIndex + 1))) != null) {
            return contentType;
        }
        return "text/plain";
    }

    private static Map<String, String> loadContentTypeByExtension() {
        HashMap<String, String> hashMap;
        ClassLoader classLoader = SessionContentReadResponse.class.getClassLoader();
        Pattern whitespace = Pattern.compile("\\s");
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("mime.types")));
        try {
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = whitespace.split(line);
                for (int i = 1; i < parts.length; ++i) {
                    map.putIfAbsent(parts[i], parts[0]);
                }
            }
            hashMap = map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return hashMap;
    }
}

