/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionUtil;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceDownload;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;

public class ApplicationPackageMaintainer
extends ConfigServerMaintainer {
    private static final Logger log = Logger.getLogger(ApplicationPackageMaintainer.class.getName());
    private final ApplicationRepository applicationRepository;
    private final File downloadDirectory;
    private final Supervisor supervisor = new Supervisor(new Transport("filedistribution-pool")).setDropEmptyBuffers(true);
    private final FileDownloader fileDownloader;

    ApplicationPackageMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource, List<String> otherConfigServersInCluster) {
        super(applicationRepository, curator, flagSource, applicationRepository.clock(), interval, false);
        this.applicationRepository = applicationRepository;
        this.downloadDirectory = new File(Defaults.getDefaults().underVespaHome(applicationRepository.configserverConfig().fileReferencesDir()));
        this.fileDownloader = ApplicationPackageMaintainer.createFileDownloader(otherConfigServersInCluster, this.downloadDirectory, this.supervisor);
    }

    protected double maintain() {
        int attempts = 0;
        int failures = 0;
        for (ApplicationId applicationId : this.applicationRepository.listApplications()) {
            Optional<FileReference> appFileReference;
            if (this.shuttingDown()) break;
            log.finest(() -> "Verifying application package for " + applicationId);
            Optional<Session> session = this.applicationRepository.getActiveSession(applicationId);
            if (session.isEmpty() || !(appFileReference = session.get().getApplicationPackageReference()).isPresent()) continue;
            long sessionId = session.get().getSessionId();
            ++attempts;
            if (!FileDistributionUtil.fileReferenceExistsOnDisk(this.downloadDirectory, appFileReference.get())) {
                log.fine(() -> "Downloading application package with file reference " + appFileReference + " for " + applicationId + " (session " + sessionId + ")");
                FileReferenceDownload download = new FileReferenceDownload(appFileReference.get(), ((Object)((Object)this)).getClass().getSimpleName(), false);
                if (this.fileDownloader.getFile(download).isEmpty()) {
                    ++failures;
                    log.info("Downloading application package (" + appFileReference + ") for " + applicationId + " (session " + sessionId + ") unsuccessful. Can be ignored unless it happens many times over a long period of time, retries is expected");
                    continue;
                }
            }
            this.createLocalSessionIfMissing(applicationId, sessionId);
        }
        return this.asSuccessFactorDeviation(attempts, failures);
    }

    private static FileDownloader createFileDownloader(List<String> otherConfigServersInCluster, File downloadDirectory, Supervisor supervisor) {
        ConfigSourceSet configSourceSet = new ConfigSourceSet(otherConfigServersInCluster);
        FileDistributionConnectionPool connectionPool = new FileDistributionConnectionPool(configSourceSet, supervisor);
        return new FileDownloader((ConnectionPool)connectionPool, supervisor, downloadDirectory, Duration.ofSeconds(300L));
    }

    public void awaitShutdown() {
        this.supervisor.transport().shutdown().join();
        this.fileDownloader.close();
        super.awaitShutdown();
    }

    private void createLocalSessionIfMissing(ApplicationId applicationId, long sessionId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        SessionRepository sessionRepository = tenant.getSessionRepository();
        if (sessionRepository.getLocalSession(sessionId) == null) {
            sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
        }
    }
}

