/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.common.collect.ImmutableSet;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.provision.TenantName;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.restapi.ErrorResponse;
import com.yahoo.restapi.RestApi;
import com.yahoo.restapi.RestApiException;
import com.yahoo.restapi.RestApiRequestHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.v2.response.ListTenantsResponse;
import com.yahoo.vespa.config.server.http.v2.response.TenantCreateResponse;
import com.yahoo.vespa.config.server.http.v2.response.TenantDeleteResponse;
import com.yahoo.vespa.config.server.http.v2.response.TenantGetResponse;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.yolean.Exceptions;
import java.util.Set;

public class TenantHandler
extends RestApiRequestHandler<TenantHandler> {
    private static final String TENANT_NAME_REGEXP = "[\\w-]+";
    private final TenantRepository tenantRepository;
    private final ApplicationRepository applicationRepository;

    @Inject
    public TenantHandler(ThreadedHttpRequestHandler.Context ctx, ApplicationRepository applicationRepository) {
        super(ctx, TenantHandler::defineApi);
        this.tenantRepository = applicationRepository.tenantRepository();
        this.applicationRepository = applicationRepository;
    }

    private RestApi defineApi() {
        return RestApi.builder().addRoute(RestApi.route((String)"/application/v2/tenant").get(this::getTenants)).addRoute(RestApi.route((String)"/application/v2/tenant/{tenant}").get(this::getTenant).put(this::putTenant).delete(this::deleteTenant)).addExceptionMapper(IllegalArgumentException.class, (c, e) -> ErrorResponse.badRequest((String)Exceptions.toMessageString((Throwable)e))).addExceptionMapper(RuntimeException.class, (c, e) -> ErrorResponse.internalServerError((String)Exceptions.toMessageString((Throwable)e))).build();
    }

    private HttpResponse getTenants(RestApi.RequestContext context) {
        return new ListTenantsResponse((Set<TenantName>)ImmutableSet.copyOf(this.tenantRepository.getAllTenantNames()));
    }

    private HttpResponse getTenant(RestApi.RequestContext context) {
        TenantName name = TenantName.from((String)context.pathParameters().getStringOrThrow("tenant"));
        if (!this.tenantRepository.checkThatTenantExists(name)) {
            throw new RestApiException.NotFound("Tenant '" + name + "' was not found.");
        }
        return new TenantGetResponse(name);
    }

    private HttpResponse putTenant(RestApi.RequestContext context) {
        TenantName name = TenantName.from((String)context.pathParameters().getStringOrThrow("tenant"));
        if (this.tenantRepository.checkThatTenantExists(name)) {
            throw new RestApiException.BadRequest("There already exists a tenant '" + name + "'");
        }
        if (!name.value().matches(TENANT_NAME_REGEXP)) {
            throw new RestApiException.BadRequest("Illegal tenant name: " + name);
        }
        this.tenantRepository.addTenant(name);
        return new TenantCreateResponse(name);
    }

    private HttpResponse deleteTenant(RestApi.RequestContext context) {
        TenantName name = TenantName.from((String)context.pathParameters().getStringOrThrow("tenant"));
        if (!this.tenantRepository.checkThatTenantExists(name)) {
            throw new RestApiException.NotFound("Tenant '" + name + "' was not found.");
        }
        this.applicationRepository.deleteTenant(name);
        return new TenantDeleteResponse(name);
    }
}

