/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.VersionCompatibility;
import com.yahoo.concurrent.StripedExecutor;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.ConfigActivationListener;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationCuratorDatabase;
import com.yahoo.vespa.config.server.application.ApplicationData;
import com.yahoo.vespa.config.server.application.ApplicationMapper;
import com.yahoo.vespa.config.server.application.ApplicationVersions;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.CompletionTimeoutException;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.ListFlag;
import com.yahoo.vespa.flags.PermanentFlags;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;

public class TenantApplications
implements RequestHandler,
HostValidator {
    private static final Logger log = Logger.getLogger(TenantApplications.class.getName());
    private final Curator curator;
    private final ApplicationCuratorDatabase database;
    private final Curator.DirectoryCache directoryCache;
    private final Executor zkWatcherExecutor;
    private final Metrics metrics;
    private final TenantName tenant;
    private final ConfigActivationListener configActivationListener;
    private final ConfigResponseFactory responseFactory;
    private final HostRegistry hostRegistry;
    private final ApplicationMapper applicationMapper = new ApplicationMapper();
    private final MetricUpdater tenantMetricUpdater;
    private final Clock clock;
    private final TenantFileSystemDirs tenantFileSystemDirs;
    private final String serverId;
    private final ListFlag<String> incompatibleVersions;
    private final BooleanFlag writeApplicationDataAsJson;
    private final BooleanFlag readApplicationDataAsJson;

    public TenantApplications(TenantName tenant, Curator curator, StripedExecutor<TenantName> zkWatcherExecutor, ExecutorService zkCacheExecutor, Metrics metrics, ConfigActivationListener configActivationListener, ConfigserverConfig configserverConfig, HostRegistry hostRegistry, TenantFileSystemDirs tenantFileSystemDirs, Clock clock, FlagSource flagSource) {
        this.curator = curator;
        this.database = new ApplicationCuratorDatabase(tenant, curator);
        this.tenant = tenant;
        this.zkWatcherExecutor = command -> zkWatcherExecutor.execute((Object)tenant, command);
        this.directoryCache = this.database.createApplicationsPathCache(zkCacheExecutor);
        this.directoryCache.addListener(this::childEvent);
        this.directoryCache.start();
        this.metrics = metrics;
        this.configActivationListener = configActivationListener;
        this.responseFactory = ConfigResponseFactory.create(configserverConfig);
        this.tenantMetricUpdater = metrics.getOrCreateMetricUpdater(Metrics.createDimensions(tenant));
        this.hostRegistry = hostRegistry;
        this.tenantFileSystemDirs = tenantFileSystemDirs;
        this.clock = clock;
        this.serverId = configserverConfig.serverId();
        this.incompatibleVersions = (ListFlag)PermanentFlags.INCOMPATIBLE_VERSIONS.bindTo(flagSource);
        this.writeApplicationDataAsJson = (BooleanFlag)Flags.WRITE_APPLICATION_DATA_AS_JSON.bindTo(flagSource);
        this.readApplicationDataAsJson = (BooleanFlag)Flags.READ_APPLICATION_DATA_AS_JSON.bindTo(flagSource);
    }

    public ApplicationCuratorDatabase database() {
        return this.database;
    }

    public List<ApplicationId> activeApplications() {
        return this.database().activeApplications();
    }

    public boolean exists(ApplicationId id) {
        return this.database().exists(id);
    }

    public Optional<Long> activeSessionOf(ApplicationId id) {
        return this.database().activeSessionOf(id);
    }

    public Optional<ApplicationData> applicationData(ApplicationId id) {
        return this.database().applicationData(id, this.readApplicationDataAsJson.value());
    }

    public boolean sessionExistsInFileSystem(long sessionId) {
        return Files.exists(Paths.get(this.tenantFileSystemDirs.sessionsPath().getAbsolutePath(), String.valueOf(sessionId)), new LinkOption[0]);
    }

    public Transaction createWriteActiveTransaction(Transaction transaction, ApplicationId applicationId, long sessionId) {
        return this.database().createWriteActiveTransaction(transaction, applicationId, sessionId, this.writeApplicationDataAsJson.value());
    }

    public Transaction createWritePrepareTransaction(Transaction transaction, ApplicationId applicationId, long sessionId, Optional<Long> activeSessionId) {
        return this.database().createWritePrepareTransaction(transaction, applicationId, sessionId, activeSessionId.map(OptionalLong::of).orElseGet(OptionalLong::empty), this.writeApplicationDataAsJson.value());
    }

    public void createApplication(ApplicationId id) {
        this.database().createApplication(id, this.writeApplicationDataAsJson.value());
    }

    public long requireActiveSessionOf(ApplicationId applicationId) {
        return this.activeSessionOf(applicationId).orElseThrow(() -> new IllegalArgumentException("Application '" + applicationId + "' has no active session."));
    }

    public CuratorTransaction createDeleteTransaction(ApplicationId applicationId) {
        return this.database().createDeleteTransaction(applicationId);
    }

    public void removeUnusedApplications() {
        this.removeApplicationsExcept(Set.copyOf(this.activeApplications()));
    }

    public void close() {
        this.directoryCache.close();
    }

    public Lock lock(ApplicationId id) {
        return this.database().lock(id);
    }

    private void childEvent(CuratorFramework ignored, PathChildrenCacheEvent event) {
        this.zkWatcherExecutor.execute(() -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    ApplicationId applicationId = ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName());
                    log.log(Level.FINE, () -> TenantRepository.logPre(applicationId) + "Application added: " + applicationId);
                    break;
                }
                case CHILD_REMOVED: {
                    this.removeApplication(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                    break;
                }
                case CHILD_UPDATED: {
                    break;
                }
            }
        });
    }

    @Override
    public ConfigResponse resolveConfig(ApplicationId appId, GetConfigRequest req, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        log.log(Level.FINE, () -> TenantRepository.logPre(appId) + "Resolving config");
        return application.resolveConfig(req, this.responseFactory);
    }

    private void notifyConfigActivationListeners(ApplicationVersions applicationVersions) {
        List<Application> applications = applicationVersions.applications();
        if (applications.isEmpty()) {
            throw new IllegalArgumentException("application set cannot be empty");
        }
        this.hostRegistry.update(applications.get(0).getId(), applicationVersions.allHosts());
        this.configActivationListener.configActivated(applicationVersions);
    }

    public void activateApplication(ApplicationVersions applicationVersions, long activeSessionId) {
        ApplicationId id = applicationVersions.getId();
        try (Lock lock = this.lock(id);){
            if (!this.exists(id)) {
                return;
            }
            if (applicationVersions.applicationGeneration() != activeSessionId) {
                return;
            }
            this.setActiveApp(applicationVersions);
            this.notifyConfigActivationListeners(applicationVersions);
        }
    }

    public void removeApplication(ApplicationId applicationId) {
        log.log(Level.FINE, () -> "Removing application " + applicationId);
        if (this.exists(applicationId)) {
            log.log(Level.INFO, "Tried removing application " + applicationId + ", but it seems to have been deployed again");
            return;
        }
        if (this.hasApplication(applicationId)) {
            this.applicationMapper.remove(applicationId);
            this.hostRegistry.removeHosts(applicationId);
            this.configActivationListenersOnRemove(applicationId);
            this.tenantMetricUpdater.setApplications(this.applicationMapper.numApplications());
            this.metrics.removeMetricUpdater(Metrics.createDimensions(applicationId));
            this.getRemoveApplicationWaiter(applicationId).notifyCompletion();
            log.log(Level.INFO, "Application removed: " + applicationId);
        }
    }

    public boolean hasApplication(ApplicationId applicationId) {
        return this.applicationMapper.hasApplication(applicationId, this.clock.instant());
    }

    public void removeApplicationsExcept(Set<ApplicationId> applications) {
        for (ApplicationId activeApplication : this.applicationMapper.listApplicationIds()) {
            if (applications.contains(activeApplication)) continue;
            Lock applicationLock = this.lock(activeApplication);
            try {
                this.removeApplication(activeApplication);
            }
            finally {
                if (applicationLock == null) continue;
                applicationLock.close();
            }
        }
    }

    private void configActivationListenersOnRemove(ApplicationId applicationId) {
        this.hostRegistry.removeHosts(applicationId);
        this.configActivationListener.applicationRemoved(applicationId);
    }

    private void setActiveApp(ApplicationVersions applicationVersions) {
        ApplicationId applicationId = applicationVersions.getId();
        Collection<String> hostsForApp = applicationVersions.allHosts();
        this.hostRegistry.update(applicationId, hostsForApp);
        applicationVersions.updateHostMetrics();
        this.tenantMetricUpdater.setApplications(this.applicationMapper.numApplications());
        this.applicationMapper.register(applicationId, applicationVersions);
    }

    @Override
    public Set<ConfigKey<?>> listNamedConfigs(ApplicationId appId, Optional<Version> vespaVersion, ConfigKey<?> keyToMatch, boolean recursive) {
        Application application = this.getApplication(appId, vespaVersion);
        return this.listConfigs(application, keyToMatch, recursive);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ConfigKey<?>> listConfigs(Application application, ConfigKey<?> keyToMatch, boolean recursive) {
        LinkedHashSet ret = new LinkedHashSet();
        for (ConfigKey<?> configKey : application.allConfigsProduced()) {
            void var6_10;
            String configId = configKey.getConfigId();
            if (recursive) {
                ConfigKey configKey2 = new ConfigKey(configKey.getName(), configId, configKey.getNamespace());
            } else {
                ConfigKey configKey3 = new ConfigKey(configKey.getName(), configId.split("/")[0], configKey.getNamespace());
            }
            if (keyToMatch != null) {
                void var6_6;
                String n = var6_10.getName();
                String ns = var6_10.getNamespace();
                if (!n.equals(keyToMatch.getName()) || !ns.equals(keyToMatch.getNamespace()) || !configId.startsWith(keyToMatch.getConfigId()) || configId.equals(keyToMatch.getConfigId())) continue;
                if (!recursive) {
                    ConfigKey configKey4 = new ConfigKey(var6_10.getName(), this.appendOneLevelOfId(keyToMatch.getConfigId(), configId), var6_10.getNamespace());
                }
                ret.add((ConfigKey<?>)var6_6);
                continue;
            }
            ret.add((ConfigKey<?>)var6_10);
        }
        return ret;
    }

    @Override
    public Set<ConfigKey<?>> listConfigs(ApplicationId appId, Optional<Version> vespaVersion, boolean recursive) {
        Application application = this.getApplication(appId, vespaVersion);
        return this.listConfigs(application, null, recursive);
    }

    String appendOneLevelOfId(String baseIdSegment, String id) {
        if ("".equals(baseIdSegment)) {
            return id.split("/")[0];
        }
        String theRest = id.substring(baseIdSegment.length());
        if ("".equals(theRest)) {
            return id;
        }
        theRest = theRest.replaceFirst("/", "");
        String theRestFirstSeg = theRest.split("/")[0];
        return baseIdSegment + "/" + theRestFirstSeg;
    }

    @Override
    public Set<ConfigKey<?>> allConfigsProduced(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.allConfigsProduced();
    }

    private Application getApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        try {
            return this.applicationMapper.getForVersion(appId, vespaVersion, this.clock.instant());
        }
        catch (VersionDoesNotExistException ex) {
            throw new NotFoundException(String.format("%sNo such application (id %s): %s", TenantRepository.logPre(this.tenant), appId, ex.getMessage()));
        }
    }

    @Override
    public Set<String> allConfigIds(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.allConfigIds();
    }

    @Override
    public boolean hasApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.hasHandler(appId, vespaVersion);
    }

    private boolean hasHandler(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.applicationMapper.hasApplicationForVersion(appId, vespaVersion, this.clock.instant());
    }

    @Override
    public ApplicationId resolveApplicationId(String hostName) {
        return this.hostRegistry.getApplicationId(hostName);
    }

    @Override
    public Set<FileReference> listFileReferences(ApplicationId applicationId) {
        return this.applicationMapper.listApplications(applicationId).stream().flatMap(app -> app.getModel().fileReferences().stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean compatibleWith(Optional<Version> vespaVersion, ApplicationId application) {
        if (vespaVersion.isEmpty()) {
            return true;
        }
        Version wantedVersion = this.applicationMapper.getForVersion(application, Optional.empty(), this.clock.instant()).getModel().wantedNodeVersion();
        return VersionCompatibility.fromVersionList((List)((ListFlag)this.incompatibleVersions.with(FetchVector.Dimension.APPLICATION_ID, application.serializedForm())).value()).accept(vespaVersion.get(), wantedVersion);
    }

    @Override
    public void verifyHosts(ApplicationId applicationId, Collection<String> newHosts) {
        this.hostRegistry.verifyHosts(applicationId, newHosts);
    }

    public TenantFileSystemDirs getTenantFileSystemDirs() {
        return this.tenantFileSystemDirs;
    }

    public Curator.CompletionWaiter createRemoveApplicationWaiter(ApplicationId applicationId) {
        return RemoveApplicationWaiter.createAndInitialize(this.curator, applicationId, this.serverId);
    }

    public Curator.CompletionWaiter getRemoveApplicationWaiter(ApplicationId applicationId) {
        return RemoveApplicationWaiter.create(this.curator, applicationId, this.serverId);
    }

    static class RemoveApplicationWaiter
    implements Curator.CompletionWaiter {
        private static final Logger log = Logger.getLogger(RemoveApplicationWaiter.class.getName());
        private static final Duration waitForAllDefault = Duration.ofSeconds(5L);
        private final Curator curator;
        private final Path barrierPath;
        private final Path waiterNode;
        private final Duration waitForAll;
        private final Clock clock = Clock.systemUTC();

        RemoveApplicationWaiter(Curator curator, ApplicationId applicationId, String serverId) {
            this(curator, applicationId, serverId, waitForAllDefault);
        }

        RemoveApplicationWaiter(Curator curator, ApplicationId applicationId, String serverId, Duration waitForAll) {
            this.barrierPath = TenantRepository.getBarriersPath().append(applicationId.tenant().value()).append("delete-application").append(applicationId.serializedForm());
            this.waiterNode = this.barrierPath.append(serverId);
            this.curator = curator;
            this.waitForAll = waitForAll;
        }

        public void awaitCompletion(Duration timeout) {
            List<String> respondents;
            try {
                respondents = this.awaitInternal(timeout);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (respondents.size() < this.barrierMemberCount()) {
                throw new CompletionTimeoutException("Timed out waiting for peer config servers to remove application (waited for barrier " + this.barrierPath + ").Got response from " + respondents + ", but need response from at least " + this.barrierMemberCount() + " server(s). Timeout passed as argument was " + timeout.toMillis() + " ms");
            }
        }

        private List<String> awaitInternal(Duration timeout) throws Exception {
            List respondents;
            Instant startTime = this.clock.instant();
            Instant endTime = startTime.plus(timeout);
            Instant gotQuorumTime = Instant.EPOCH;
            do {
                respondents = (List)this.curator.framework().getChildren().forPath(this.barrierPath.getAbsolute());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + respondents + ", all participants: " + this.curator.zooKeeperEnsembleConnectionSpec());
                }
                if (respondents.size() == this.curator.zooKeeperEnsembleCount()) {
                    this.logBarrierCompleted(respondents, startTime);
                    break;
                }
                if (respondents.size() >= this.barrierMemberCount()) {
                    if (gotQuorumTime.isBefore(startTime)) {
                        gotQuorumTime = this.clock.instant();
                    }
                    if (Duration.between(this.clock.instant(), gotQuorumTime.plus(this.waitForAll)).isNegative()) {
                        this.logBarrierCompleted(respondents, startTime);
                        break;
                    }
                }
                Thread.sleep(100L);
            } while (this.clock.instant().isBefore(endTime));
            return respondents;
        }

        private void logBarrierCompleted(List<String> respondents, Instant startTime) {
            Duration duration = Duration.between(startTime, Instant.now());
            Level level = duration.minus(Duration.ofSeconds(5L)).isNegative() ? Level.FINE : Level.INFO;
            log.log(level, () -> this.barrierCompletedMessage(respondents, duration));
        }

        private String barrierCompletedMessage(List<String> respondents, Duration duration) {
            return this.barrierPath + " completed in " + duration.toString() + ", " + respondents.size() + "/" + this.curator.zooKeeperEnsembleCount() + " responded: " + respondents;
        }

        public void notifyCompletion() {
            try {
                this.curator.framework().create().forPath(this.waiterNode.getAbsolute());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "'" + this.barrierPath + "', " + this.barrierMemberCount() + " members";
        }

        public static Curator.CompletionWaiter create(Curator curator, ApplicationId applicationId, String serverId) {
            return new RemoveApplicationWaiter(curator, applicationId, serverId);
        }

        public static Curator.CompletionWaiter create(Curator curator, ApplicationId applicationId, String serverId, Duration waitForAll) {
            return new RemoveApplicationWaiter(curator, applicationId, serverId, waitForAll);
        }

        public static Curator.CompletionWaiter createAndInitialize(Curator curator, ApplicationId applicationId, String serverId) {
            return RemoveApplicationWaiter.createAndInitialize(curator, applicationId, serverId, waitForAllDefault);
        }

        public static Curator.CompletionWaiter createAndInitialize(Curator curator, ApplicationId applicationId, String serverId, Duration waitForAll) {
            RemoveApplicationWaiter waiter = new RemoveApplicationWaiter(curator, applicationId, serverId, waitForAll);
            Path barrierPath = waiter.barrierPath();
            curator.delete(barrierPath);
            curator.create(barrierPath.getParentPath());
            curator.createAtomically(new Path[]{barrierPath});
            return waiter;
        }

        private int barrierMemberCount() {
            return this.curator.zooKeeperEnsembleCount() / 2 + 1;
        }

        private Path barrierPath() {
            return this.barrierPath;
        }
    }
}

