/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.UserConfigDefinitionRepo;
import com.yahoo.vespa.config.server.deploy.ZooKeeperClient;
import com.yahoo.vespa.config.server.deploy.ZooKeeperDeployer;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import com.yahoo.vespa.config.server.filedistribution.MockFileManager;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.tenant.CloudAccountSerializer;
import com.yahoo.vespa.config.server.tenant.DataplaneTokenSerializer;
import com.yahoo.vespa.config.server.tenant.OperatorCertificateSerializer;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.server.tenant.TenantSecretStoreSerializer;
import com.yahoo.vespa.config.server.zookeeper.ZKApplicationPackage;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import com.yahoo.yolean.Exceptions;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionZooKeeperClient {
    private static final Logger log = Logger.getLogger(SessionZooKeeperClient.class.getName());
    static final String APPLICATION_ID_PATH = "applicationId";
    static final String APPLICATION_PACKAGE_REFERENCE_PATH = "applicationPackageReference";
    private static final String VERSION_PATH = "version";
    private static final String CREATE_TIME_PATH = "createTime";
    private static final String DOCKER_IMAGE_REPOSITORY_PATH = "dockerImageRepository";
    private static final String ATHENZ_DOMAIN = "athenzDomain";
    private static final String QUOTA_PATH = "quota";
    private static final String TENANT_SECRET_STORES_PATH = "tenantSecretStores";
    private static final String OPERATOR_CERTIFICATES_PATH = "operatorCertificates";
    private static final String CLOUD_ACCOUNT_PATH = "cloudAccount";
    private static final String DATAPLANE_TOKENS_PATH = "dataplaneTokens";
    private final Curator curator;
    private final TenantName tenantName;
    private final long sessionId;
    private final Path sessionPath;
    private final Path sessionStatusPath;
    private final String serverId;
    private final int maxNodeSize;
    private final AddFileInterface fileManager;
    private final Duration barrierWaitForAllTimeout;
    private static final String PREPARE_BARRIER = "prepareBarrier";
    private static final String ACTIVE_BARRIER = "activeBarrier";
    private static final String UPLOAD_BARRIER = "uploadBarrier";

    public SessionZooKeeperClient(Curator curator, TenantName tenantName, long sessionId, ConfigserverConfig configserverConfig, AddFileInterface fileManager, int maxNodeSize) {
        this.curator = curator;
        this.tenantName = tenantName;
        this.sessionId = sessionId;
        this.sessionPath = SessionZooKeeperClient.getSessionPath(tenantName, sessionId);
        this.serverId = configserverConfig.serverId();
        this.sessionStatusPath = this.sessionPath.append("/sessionState");
        this.maxNodeSize = maxNodeSize;
        this.fileManager = fileManager;
        this.barrierWaitForAllTimeout = Duration.ofSeconds(configserverConfig.barrierWaitForAllTimeout());
    }

    public SessionZooKeeperClient(Curator curator, TenantName tenantName, long sessionId, ConfigserverConfig configserverConfig) {
        this(curator, tenantName, sessionId, configserverConfig, new MockFileManager(), 0xA00000);
    }

    public void writeStatus(Session.Status sessionStatus) {
        try {
            this.createWriteStatusTransaction(sessionStatus).commit();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write session status", e);
        }
    }

    public Session.Status readStatus() {
        try {
            Optional data = this.curator.getData(this.sessionStatusPath);
            return data.map(d -> Session.Status.parse(Utf8.toString((byte[])d))).orElse(Session.Status.UNKNOWN);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Failed to read session status from " + this.sessionStatusPath.getAbsolute() + ", returning session status 'unknown'");
            return Session.Status.UNKNOWN;
        }
    }

    public long sessionId() {
        return this.sessionId;
    }

    public Curator.CompletionWaiter createActiveWaiter() {
        return this.createCompletionWaiter(ACTIVE_BARRIER);
    }

    Curator.CompletionWaiter createPrepareWaiter() {
        return this.createCompletionWaiter(PREPARE_BARRIER);
    }

    Curator.CompletionWaiter getPrepareWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(PREPARE_BARRIER));
    }

    Curator.CompletionWaiter getActiveWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(ACTIVE_BARRIER));
    }

    Curator.CompletionWaiter getUploadWaiter() {
        return this.getCompletionWaiter(this.getWaiterPath(UPLOAD_BARRIER));
    }

    private Path getWaiterPath(String barrierName) {
        return this.sessionPath.append(barrierName);
    }

    private Curator.CompletionWaiter createCompletionWaiter(String waiterNode) {
        return this.curator.createCompletionWaiter(this.sessionPath, waiterNode, this.serverId, this.barrierWaitForAllTimeout);
    }

    private Curator.CompletionWaiter getCompletionWaiter(Path path) {
        return this.curator.getCompletionWaiter(path, this.serverId, this.barrierWaitForAllTimeout);
    }

    public CuratorTransaction deleteTransaction() {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.sessionPath.getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public ApplicationPackage loadApplicationPackage() {
        return new ZKApplicationPackage(this.fileManager, this.curator, this.sessionPath, this.maxNodeSize);
    }

    public ConfigDefinitionRepo getUserConfigDefinitions() {
        return new UserConfigDefinitionRepo(this.curator, this.sessionPath.append("/userdefconfigs"));
    }

    private Path applicationIdPath() {
        return this.sessionPath.append(APPLICATION_ID_PATH);
    }

    public void writeApplicationId(ApplicationId id) {
        if (!id.tenant().equals((Object)this.tenantName)) {
            throw new IllegalArgumentException("Cannot write application id '" + id + "' for tenant '" + this.tenantName + "'");
        }
        this.curator.set(this.applicationIdPath(), Utf8.toBytes((String)id.serializedForm()));
    }

    public ApplicationId readApplicationId() {
        return this.curator.getData(this.applicationIdPath()).map(d -> ApplicationId.fromSerializedForm((String)Utf8.toString((byte[])d))).orElseThrow(() -> new NotFoundException("Could not find application id for session " + this.sessionId));
    }

    void writeApplicationPackageReference(Optional<FileReference> applicationPackageReference) {
        applicationPackageReference.ifPresent(reference -> this.curator.set(this.applicationPackageReferencePath(), Utf8.toBytes((String)reference.value())));
    }

    FileReference readApplicationPackageReference() {
        Optional data = this.curator.getData(this.applicationPackageReferencePath());
        if (data.isEmpty()) {
            return null;
        }
        return new FileReference(Utf8.toString((byte[])((byte[])data.get())));
    }

    private Path applicationPackageReferencePath() {
        return this.sessionPath.append(APPLICATION_PACKAGE_REFERENCE_PATH);
    }

    private Path versionPath() {
        return this.sessionPath.append(VERSION_PATH);
    }

    private Path dockerImageRepositoryPath() {
        return this.sessionPath.append(DOCKER_IMAGE_REPOSITORY_PATH);
    }

    private Path athenzDomainPath() {
        return this.sessionPath.append(ATHENZ_DOMAIN);
    }

    private Path quotaPath() {
        return this.sessionPath.append(QUOTA_PATH);
    }

    private Path tenantSecretStorePath() {
        return this.sessionPath.append(TENANT_SECRET_STORES_PATH);
    }

    private Path operatorCertificatesPath() {
        return this.sessionPath.append(OPERATOR_CERTIFICATES_PATH);
    }

    private Path cloudAccountPath() {
        return this.sessionPath.append(CLOUD_ACCOUNT_PATH);
    }

    private Path dataplaneTokensPath() {
        return this.sessionPath.append(DATAPLANE_TOKENS_PATH);
    }

    public void writeVespaVersion(Version version) {
        this.curator.set(this.versionPath(), Utf8.toBytes((String)version.toString()));
    }

    public Version readVespaVersion() {
        Optional data = this.curator.getData(this.versionPath());
        return data.map(d -> new Version(Utf8.toString((byte[])d))).orElse(Vtag.currentVersion);
    }

    public Optional<DockerImage> readDockerImageRepository() {
        Optional dockerImageRepository = this.curator.getData(this.dockerImageRepositoryPath());
        return dockerImageRepository.map(d -> DockerImage.fromString((String)Utf8.toString((byte[])d)));
    }

    public void writeDockerImageRepository(Optional<DockerImage> dockerImageRepository) {
        dockerImageRepository.ifPresent(repo -> this.curator.set(this.dockerImageRepositoryPath(), Utf8.toBytes((String)repo.untagged())));
    }

    public Instant readCreateTime() {
        Optional data = this.curator.getData(this.getCreateTimePath());
        return data.map(d -> Instant.ofEpochSecond(Long.parseLong(Utf8.toString((byte[])d)))).orElse(Instant.EPOCH);
    }

    public Instant readActivatedTime() {
        Optional statData = this.curator.getStat(this.sessionStatusPath);
        return statData.map(s -> Instant.ofEpochMilli(s.getMtime())).orElse(Instant.EPOCH);
    }

    private Path getCreateTimePath() {
        return this.sessionPath.append(CREATE_TIME_PATH);
    }

    AllocatedHosts getAllocatedHosts() {
        return (AllocatedHosts)this.loadApplicationPackage().getAllocatedHosts().orElseThrow(() -> new IllegalStateException("Allocated hosts does not exists"));
    }

    public ZooKeeperDeployer createDeployer(DeployLogger logger) {
        ZooKeeperClient zkClient = new ZooKeeperClient(this.curator, logger, this.sessionPath);
        return new ZooKeeperDeployer(zkClient);
    }

    public Transaction createWriteStatusTransaction(Session.Status status) {
        CuratorTransaction transaction = new CuratorTransaction(this.curator);
        if (this.curator.exists(this.sessionStatusPath)) {
            transaction.add((Transaction.Operation)CuratorOperations.setData((String)this.sessionStatusPath.getAbsolute(), (byte[])Utf8.toBytes((String)status.name())));
        } else {
            transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionStatusPath.getAbsolute(), (byte[])Utf8.toBytes((String)status.name())));
        }
        return transaction;
    }

    public void writeAthenzDomain(Optional<AthenzDomain> athenzDomain) {
        athenzDomain.ifPresent(domain -> this.curator.set(this.athenzDomainPath(), Utf8.toBytes((String)domain.value())));
    }

    public Optional<AthenzDomain> readAthenzDomain() {
        return this.curator.getData(this.athenzDomainPath()).map(Utf8::toString).filter(domain -> !domain.isBlank()).map(AthenzDomain::from);
    }

    public void writeQuota(Optional<Quota> maybeQuota) {
        maybeQuota.ifPresent(quota -> {
            byte[] bytes = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)quota.toSlime()));
            this.curator.set(this.quotaPath(), bytes);
        });
    }

    public Optional<Quota> readQuota() {
        return this.curator.getData(this.quotaPath()).map(SlimeUtils::jsonToSlime).map(slime -> Quota.fromSlime((Inspector)slime.get()));
    }

    public void writeTenantSecretStores(List<TenantSecretStore> tenantSecretStores) {
        if (!tenantSecretStores.isEmpty()) {
            byte[] bytes = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)TenantSecretStoreSerializer.toSlime(tenantSecretStores)));
            this.curator.set(this.tenantSecretStorePath(), bytes);
        }
    }

    public List<TenantSecretStore> readTenantSecretStores() {
        return this.curator.getData(this.tenantSecretStorePath()).map(SlimeUtils::jsonToSlime).map(slime -> TenantSecretStoreSerializer.listFromSlime((Inspector)slime.get())).orElse(List.of());
    }

    public void writeOperatorCertificates(List<X509Certificate> certificates) {
        if (!certificates.isEmpty()) {
            byte[] bytes = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)OperatorCertificateSerializer.toSlime(certificates)));
            this.curator.set(this.operatorCertificatesPath(), bytes);
        }
    }

    public List<X509Certificate> readOperatorCertificates() {
        return this.curator.getData(this.operatorCertificatesPath()).map(SlimeUtils::jsonToSlime).map(slime -> OperatorCertificateSerializer.fromSlime((Inspector)slime.get())).orElse(List.of());
    }

    public void writeCloudAccount(Optional<CloudAccount> cloudAccount) {
        if (cloudAccount.isPresent()) {
            byte[] data = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)CloudAccountSerializer.toSlime((CloudAccount)cloudAccount.get())));
            this.curator.set(this.cloudAccountPath(), data);
        } else {
            this.curator.delete(this.cloudAccountPath());
        }
    }

    public Optional<CloudAccount> readCloudAccount() {
        return this.curator.getData(this.cloudAccountPath()).map(SlimeUtils::jsonToSlime).map(slime -> CloudAccountSerializer.fromSlime((Inspector)slime.get()));
    }

    public void writeDataplaneTokens(List<DataplaneToken> dataplaneTokens) {
        byte[] data = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)DataplaneTokenSerializer.toSlime(dataplaneTokens)));
        this.curator.set(this.dataplaneTokensPath(), data);
    }

    public List<DataplaneToken> readDataplaneTokens() {
        return this.curator.getData(this.dataplaneTokensPath()).map(SlimeUtils::jsonToSlime).map(slime -> DataplaneTokenSerializer.fromSlime((Inspector)slime.get())).orElse(List.of());
    }

    public void createNewSession(Instant createTime) {
        CuratorTransaction transaction = new CuratorTransaction(this.curator);
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionPath.getAbsolute()));
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.sessionPath.append(UPLOAD_BARRIER).getAbsolute()));
        transaction.add(this.createWriteStatusTransaction(Session.Status.NEW).operations());
        transaction.add((Transaction.Operation)CuratorOperations.create((String)this.getCreateTimePath().getAbsolute(), (byte[])Utf8.toBytes((String)String.valueOf(createTime.getEpochSecond()))));
        transaction.commit();
    }

    private static Path getSessionPath(TenantName tenantName, long sessionId) {
        return TenantRepository.getSessionsPath(tenantName).append(String.valueOf(sessionId));
    }
}

