/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.google.common.collect.ImmutableSet;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationCuratorDatabase;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.modelfactory.LegacyFlags;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelsBuilder;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointsCache;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataStore;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateRetriever;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivatedModelsBuilder
extends ModelsBuilder<Application> {
    private static final Logger log = Logger.getLogger(ActivatedModelsBuilder.class.getName());
    private final TenantName tenant;
    private final long applicationGeneration;
    private final SessionZooKeeperClient zkClient;
    private final Optional<ApplicationSet> currentActiveApplicationSet;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final Metrics metrics;
    private final Curator curator;
    private final FlagSource flagSource;
    private final SecretStore secretStore;
    private final ExecutorService executor;

    public ActivatedModelsBuilder(TenantName tenant, long applicationGeneration, SessionZooKeeperClient zkClient, Optional<ApplicationSet> currentActiveApplicationSet, ExecutorService executor, Curator curator, Metrics metrics, FlagSource flagSource, SecretStore secretStore, HostProvisionerProvider hostProvisionerProvider, ConfigserverConfig configserverConfig, Zone zone, ModelFactoryRegistry modelFactoryRegistry, ConfigDefinitionRepo configDefinitionRepo) {
        super(modelFactoryRegistry, configserverConfig, zone, hostProvisionerProvider, new SilentDeployLogger());
        this.tenant = tenant;
        this.applicationGeneration = applicationGeneration;
        this.zkClient = zkClient;
        this.currentActiveApplicationSet = currentActiveApplicationSet;
        this.configDefinitionRepo = configDefinitionRepo;
        this.metrics = metrics;
        this.curator = curator;
        this.flagSource = flagSource;
        this.secretStore = secretStore;
        this.executor = executor;
    }

    @Override
    protected Application buildModelVersion(ModelFactory modelFactory, ApplicationPackage applicationPackage, ApplicationId applicationId, Optional<DockerImage> wantedDockerImageRepository, Version wantedNodeVespaVersion) {
        log.log(Level.FINE, () -> String.format("Loading model version %s for session %s application %s", modelFactory.version(), this.applicationGeneration, applicationId));
        ModelContext.Properties modelContextProperties = this.createModelContextProperties(applicationId, modelFactory.version(), applicationPackage);
        Provisioned provisioned = new Provisioned();
        ModelContextImpl modelContext = new ModelContextImpl(applicationPackage, this.modelOf(modelFactory.version()), new SilentDeployLogger(), this.configDefinitionRepo, (FileRegistry)ActivatedModelsBuilder.getForVersionOrLatest(applicationPackage.getFileRegistries(), modelFactory.version()).orElse(new MockFileRegistry()), this.executor, new ApplicationCuratorDatabase(this.tenant, this.curator).readReindexingStatus(applicationId), this.createStaticProvisioner(applicationPackage, modelContextProperties.applicationId(), provisioned), provisioned, modelContextProperties, Optional.empty(), wantedDockerImageRepository, modelFactory.version(), wantedNodeVespaVersion);
        MetricUpdater applicationMetricUpdater = this.metrics.getOrCreateMetricUpdater(Metrics.createDimensions(applicationId));
        ServerCache serverCache = new ServerCache(this.configDefinitionRepo, this.zkClient.getUserConfigDefinitions());
        return new Application(modelFactory.createModel((ModelContext)modelContext), serverCache, this.applicationGeneration, modelFactory.version(), applicationMetricUpdater, applicationId);
    }

    private Optional<Model> modelOf(Version version) {
        if (this.currentActiveApplicationSet.isEmpty()) {
            return Optional.empty();
        }
        return this.currentActiveApplicationSet.get().get(version).map(Application::getModel);
    }

    private static <T> Optional<T> getForVersionOrLatest(Map<Version, T> map, Version version) {
        if (map.isEmpty()) {
            return Optional.empty();
        }
        T value = map.get(version);
        if (value == null) {
            value = map.get(map.keySet().stream().max(Comparator.naturalOrder()).get());
        }
        return Optional.of(value);
    }

    private ModelContext.Properties createModelContextProperties(ApplicationId applicationId, Version modelVersion, ApplicationPackage applicationPackage) {
        return new ModelContextImpl.Properties(applicationId, modelVersion, this.configserverConfig, this.zone(), (Set<ContainerEndpoint>)ImmutableSet.copyOf(new ContainerEndpointsCache(TenantRepository.getTenantPath(this.tenant), this.curator).read(applicationId)), false, false, LegacyFlags.from(applicationPackage, this.flagSource), new EndpointCertificateMetadataStore(this.curator, TenantRepository.getTenantPath(this.tenant)).readEndpointCertificateMetadata(applicationId).flatMap(new EndpointCertificateRetriever(this.secretStore)::readEndpointCertificateSecrets), this.zkClient.readAthenzDomain(), this.zkClient.readQuota(), this.zkClient.readTenantSecretStores(), this.secretStore, this.zkClient.readOperatorCertificates(), this.zkClient.readCloudAccount(), this.zkClient.readDataplaneTokens());
    }
}

