/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.http.SessionHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.http.v2.SessionCreateHandler;
import com.yahoo.vespa.config.server.http.v2.SessionPrepareAndActivateResponse;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.time.Duration;
import java.time.Instant;

public class ApplicationApiHandler
extends SessionHandler {
    public static final String APPLICATION_X_GZIP = "application/x-gzip";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String contentTypeHeader = "Content-Type";
    private final TenantRepository tenantRepository;
    private final Duration zookeeperBarrierTimeout;
    private final Zone zone;

    @Inject
    public ApplicationApiHandler(LoggingRequestHandler.Context ctx, ApplicationRepository applicationRepository, TenantRepository tenantRepository, ConfigserverConfig configserverConfig, Zone zone) {
        super(ctx, applicationRepository);
        this.tenantRepository = tenantRepository;
        this.zookeeperBarrierTimeout = Duration.ofSeconds(configserverConfig.zookeeper().barrierTimeout());
        this.zone = zone;
    }

    @Override
    protected HttpResponse handlePUT(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        TenantName tenantName = tenant.getName();
        long sessionId = ApplicationApiHandler.getSessionIdV2(request);
        PrepareParams prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
        PrepareResult result = this.applicationRepository.prepareAndActivate(tenant, sessionId, prepareParams, ApplicationApiHandler.shouldIgnoreSessionStaleFailure(request), Instant.now());
        return new SessionPrepareAndActivateResponse(result, tenantName, request, prepareParams.getApplicationId(), this.zone);
    }

    @Override
    protected HttpResponse handlePOST(HttpRequest request) {
        Tenant tenant = this.getExistingTenant(request);
        TenantName tenantName = tenant.getName();
        PrepareParams prepareParams = PrepareParams.fromHttpRequest(request, tenantName, this.zookeeperBarrierTimeout);
        SessionCreateHandler.validateDataAndHeader(request);
        PrepareResult result = this.applicationRepository.deploy(CompressedApplicationInputStream.createFromCompressedStream(request.getData(), request.getHeader(contentTypeHeader)), prepareParams, ApplicationApiHandler.shouldIgnoreSessionStaleFailure(request), Instant.now());
        return new SessionPrepareAndActivateResponse(result, tenantName, request, prepareParams.getApplicationId(), this.zone);
    }

    public Duration getTimeout() {
        return this.zookeeperBarrierTimeout.plus(Duration.ofSeconds(10L));
    }

    private Tenant getExistingTenant(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromSessionRequest(request);
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        return this.tenantRepository.getTenant(tenantName);
    }
}

