/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class ClusterInfo {
    private final String clusterId;
    private final ClusterType clusterType;
    private final List<URI> hostnames;

    public ClusterInfo(String clusterId, ClusterType clusterType) {
        this(clusterId, clusterType, new ArrayList<URI>());
    }

    public ClusterInfo(String clusterId, ClusterType clusterType, List<URI> hostnames) {
        this.clusterId = clusterId;
        this.clusterType = clusterType;
        this.hostnames = hostnames;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public List<URI> getHostnames() {
        return this.hostnames;
    }

    public void addHost(URI host) {
        this.hostnames.add(host);
    }

    public static enum ClusterType {
        content,
        container;


        public static boolean isValidType(String enumString) {
            try {
                ClusterType.valueOf(enumString);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
    }
}

