/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.version;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.io.IOUtils;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class VersionState {
    private final File versionFile;

    @Inject
    public VersionState(ConfigserverConfig config) {
        this(new File(Defaults.getDefaults().underVespaHome(config.configServerDBDir()), "vespa_version"));
    }

    public VersionState(File versionFile) {
        this.versionFile = versionFile;
    }

    public boolean isUpgraded() {
        return this.currentVersion().compareTo(this.storedVersion()) > 0;
    }

    public void saveNewVersion() {
        try (FileWriter writer = new FileWriter(this.versionFile);){
            writer.write(this.currentVersion().toFullString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Version storedVersion() {
        Version version;
        FileReader reader = new FileReader(this.versionFile);
        try {
            version = Version.fromString((String)IOUtils.readAll((Reader)reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return new Version(0, 0, 0);
            }
        }
        reader.close();
        return version;
    }

    public Version currentVersion() {
        return new Version(7, 87, 44);
    }

    public String toString() {
        return String.format("Current version:%s, stored version:%s", this.currentVersion(), this.storedVersion());
    }
}

