/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.MetricsAggregator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class MetricsResponse
extends HttpResponse {
    private final Slime slime = new Slime();

    public MetricsResponse(int status, ApplicationId applicationId, Map<ClusterInfo, MetricsAggregator> aggregatedMetrics) {
        super(status);
        Cursor application = this.slime.setObject();
        application.setString("applicationId", applicationId.serializedForm());
        Cursor clusters = application.setArray("clusters");
        for (Map.Entry<ClusterInfo, MetricsAggregator> entry : aggregatedMetrics.entrySet()) {
            Cursor cluster = clusters.addObject();
            cluster.setString("clusterId", entry.getKey().getClusterId());
            cluster.setString("clusterType", entry.getKey().getClusterType().name());
            MetricsAggregator aggregator = entry.getValue();
            Cursor metrics = cluster.setObject("metrics");
            aggregator.aggregateQueryRate().ifPresent(queryRate -> metrics.setDouble("queriesPerSecond", queryRate.doubleValue()));
            aggregator.aggregateFeedRate().ifPresent(feedRate -> metrics.setDouble("feedPerSecond", feedRate.doubleValue()));
            aggregator.aggregateDocumentCount().ifPresent(documentCount -> metrics.setDouble("documentCount", documentCount.doubleValue()));
            aggregator.aggregateQueryLatency().ifPresent(queryLatency -> metrics.setDouble("queryLatency", queryLatency.doubleValue()));
            aggregator.aggregateFeedLatency().ifPresent(feedLatency -> metrics.setDouble("feedLatency", feedLatency.doubleValue()));
        }
    }

    public void render(OutputStream outputStream) throws IOException {
        new JsonFormat(false).encode(outputStream, this.slime);
    }

    public String getContentType() {
        return "application/json";
    }
}

