/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.serviceview;

import com.yahoo.container.jaxrs.annotation.Component;
import com.yahoo.vespa.serviceview.ConfigServerLocation;
import com.yahoo.vespa.serviceview.Service;
import com.yahoo.vespa.serviceview.ServiceModel;
import com.yahoo.vespa.serviceview.bindings.ApplicationView;
import com.yahoo.vespa.serviceview.bindings.ConfigClient;
import com.yahoo.vespa.serviceview.bindings.HealthClient;
import com.yahoo.vespa.serviceview.bindings.ModelResponse;
import com.yahoo.vespa.serviceview.bindings.StateClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.client.proxy.WebResourceFactory;

@Path(value="/")
public class StateResource
implements StateClient {
    private static final String USER_AGENT = "service-view-config-server-client";
    private static final String SINGLE_API_LINK = "url";
    private final int restApiPort;
    private final String host;
    private final UriInfo uriInfo;

    public StateResource(@Component ConfigServerLocation configServer, @Context UriInfo ui) {
        this.restApiPort = configServer.restApiPort;
        this.host = "localhost";
        this.uriInfo = ui;
    }

    @GET
    @Path(value="v1/")
    @Produces(value={"application/json"})
    public ApplicationView getDefaultUserInfo() {
        return this.getUserInfo("default", "default", "default", "default", "default");
    }

    @GET
    @Path(value="v1/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}")
    @Produces(value={"application/json"})
    public ApplicationView getUserInfo(@PathParam(value="tenantName") String tenantName, @PathParam(value="applicationName") String applicationName, @PathParam(value="environmentName") String environmentName, @PathParam(value="regionName") String regionName, @PathParam(value="instanceName") String instanceName) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        return model.showAllClusters(this.getBaseUri() + "v1/", this.applicationIdentifier(tenantName, applicationName, environmentName, regionName, instanceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="v1/legacy/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}/service/{serviceIdentifier}/{apiParams: .*}")
    @Produces(value={"text/html"})
    public String htmlProxy(@PathParam(value="tenantName") String tenantName, @PathParam(value="applicationName") String applicationName, @PathParam(value="environmentName") String environmentName, @PathParam(value="regionName") String regionName, @PathParam(value="instanceName") String instanceName, @PathParam(value="serviceIdentifier") String identifier, @PathParam(value="apiParams") String apiParams) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        Service s = model.getService(identifier);
        int requestedPort = s.matchIdentifierWithPort(identifier);
        try (Client client = StateResource.client();){
            StringBuilder uriBuffer = new StringBuilder("http://").append(s.host).append(':').append(requestedPort).append('/').append(apiParams);
            this.addQuery(uriBuffer);
            String uri = uriBuffer.toString();
            WebTarget target = client.target(uri);
            HtmlProxyHack resource = (HtmlProxyHack)WebResourceFactory.newResource(HtmlProxyHack.class, (WebTarget)target);
            String string = resource.proxy();
            return string;
        }
    }

    private String getBaseUri() {
        String baseUri = this.uriInfo.getBaseUri().toString();
        if (baseUri.endsWith("/")) {
            return baseUri;
        }
        return baseUri + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelResponse getModelConfig(String tenant, String application, String environment, String region, String instance) {
        try (Client client = StateResource.client();){
            WebTarget target = client.target("http://" + this.host + ":" + this.restApiPort + "/");
            ConfigClient resource = (ConfigClient)WebResourceFactory.newResource(ConfigClient.class, (WebTarget)target);
            ModelResponse modelResponse = resource.getServiceModel(tenant, application, environment, region, instance);
            return modelResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="v1/tenant/{tenantName}/application/{applicationName}/environment/{environmentName}/region/{regionName}/instance/{instanceName}/service/{serviceIdentifier}/{apiParams: .*}")
    @Produces(value={"application/json"})
    public HashMap singleService(@PathParam(value="tenantName") String tenantName, @PathParam(value="applicationName") String applicationName, @PathParam(value="environmentName") String environmentName, @PathParam(value="regionName") String regionName, @PathParam(value="instanceName") String instanceName, @PathParam(value="serviceIdentifier") String identifier, @PathParam(value="apiParams") String apiParams) {
        ServiceModel model = new ServiceModel(this.getModelConfig(tenantName, applicationName, environmentName, regionName, instanceName));
        Service s = model.getService(identifier);
        int requestedPort = s.matchIdentifierWithPort(identifier);
        try (Client client = StateResource.client();){
            HealthClient resource = this.getHealthClient(apiParams, s, requestedPort, client);
            HashMap apiResult = resource.getHealthInfo();
            this.rewriteResourceLinks(apiResult, model, s, this.applicationIdentifier(tenantName, applicationName, environmentName, regionName, instanceName), identifier);
            HashMap hashMap = apiResult;
            return hashMap;
        }
    }

    protected HealthClient getHealthClient(String apiParams, Service s, int requestedPort, Client client) {
        StringBuilder uriBuffer = new StringBuilder("http://").append(s.host).append(':').append(requestedPort).append('/').append(apiParams);
        this.addQuery(uriBuffer);
        WebTarget target = client.target(uriBuffer.toString());
        return (HealthClient)WebResourceFactory.newResource(HealthClient.class, (WebTarget)target);
    }

    private String applicationIdentifier(String tenant, String application, String environment, String region, String instance) {
        return "tenant/" + tenant + "/application/" + application + "/environment/" + environment + "/region/" + region + "/instance/" + instance;
    }

    private void rewriteResourceLinks(Object apiResult, ServiceModel model, Service self, String applicationIdentifier, String incomingIdentifier) {
        block9: {
            block10: {
                if (!(apiResult instanceof List)) break block10;
                ListIterator<String> i = ((List)apiResult).listIterator();
                while (i.hasNext()) {
                    Object resource = i.next();
                    if (resource instanceof String) {
                        try {
                            StringBuilder stringBuilder = this.linkBuffer(applicationIdentifier);
                            this.retarget(model, self, stringBuilder, (String)resource);
                            i.set(stringBuilder.toString());
                            continue;
                        }
                        catch (GiveUpLinkRetargetingException giveUpLinkRetargetingException) {
                            break block9;
                        }
                    }
                    this.rewriteResourceLinks(resource, model, self, applicationIdentifier, incomingIdentifier);
                }
                break block9;
            }
            if (!(apiResult instanceof Map)) break block9;
            Map api = (Map)apiResult;
            for (Map.Entry<Object, Object> entry : api.entrySet()) {
                if (SINGLE_API_LINK.equals(entry.getKey()) && entry.getValue() instanceof String) {
                    try {
                        this.rewriteSingleLink(entry, model, self, this.linkBuffer(applicationIdentifier));
                    }
                    catch (GiveUpLinkRetargetingException giveUpLinkRetargetingException) {}
                    continue;
                }
                if ("link".equals(entry.getKey()) && entry.getValue() instanceof String) {
                    this.buildSingleLink(entry, this.linkBuffer(applicationIdentifier), incomingIdentifier);
                    continue;
                }
                this.rewriteResourceLinks(entry.getValue(), model, self, applicationIdentifier, incomingIdentifier);
            }
        }
    }

    private void buildSingleLink(Map.Entry<Object, Object> entry, StringBuilder newUri, String incomingIdentifier) {
        newUri.append("/service/").append(incomingIdentifier);
        newUri.append(entry.getValue());
        entry.setValue(newUri.toString());
    }

    private void addQuery(StringBuilder newUri) {
        String query = this.uriInfo.getRequestUri().getRawQuery();
        if (query != null && query.length() > 0) {
            newUri.append('?').append(query);
        }
    }

    private StringBuilder linkBuffer(String applicationIdentifier) {
        StringBuilder newUri = new StringBuilder(this.getBaseUri());
        newUri.append("v1/").append(applicationIdentifier);
        return newUri;
    }

    private void rewriteSingleLink(Map.Entry<Object, Object> entry, ServiceModel model, Service self, StringBuilder newUri) throws GiveUpLinkRetargetingException {
        String url = (String)entry.getValue();
        this.retarget(model, self, newUri, url);
        entry.setValue(newUri.toString());
    }

    private void retarget(ServiceModel model, Service self, StringBuilder newUri, String url) throws GiveUpLinkRetargetingException {
        Service s;
        URI link;
        try {
            link = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new GiveUpLinkRetargetingException(e);
        }
        if (!link.isAbsolute()) {
            throw new GiveUpLinkRetargetingException("This rewriting only supports absolute URIs.");
        }
        int linkPort = link.getPort();
        if (linkPort == -1) {
            linkPort = 80;
        }
        try {
            s = model.resolve(link.getHost(), linkPort, self);
        }
        catch (IllegalArgumentException e) {
            throw new GiveUpLinkRetargetingException(e);
        }
        newUri.append("/service/").append(s.getIdentifier(linkPort));
        newUri.append(link.getRawPath());
    }

    private static Client client() {
        return ((ClientBuilder)ClientBuilder.newBuilder().register(ctx -> ctx.getHeaders().put((Object)"User-Agent", Collections.singletonList(USER_AGENT)))).build();
    }

    @Produces(value={"text/html"})
    public static interface HtmlProxyHack {
        @GET
        public String proxy();
    }

    private static class GiveUpLinkRetargetingException
    extends Exception {
        public GiveUpLinkRetargetingException(Throwable reason) {
            super(reason);
        }

        public GiveUpLinkRetargetingException(String message) {
            super(message);
        }
    }
}

