/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class HttpErrorResponse
extends HttpResponse {
    private static final Logger log = Logger.getLogger(HttpErrorResponse.class.getName());
    private final Slime slime = new Slime();

    public HttpErrorResponse(int code, String errorType, String msg) {
        super(code);
        Cursor root = this.slime.setObject();
        root.setString("error-code", errorType);
        root.setString("message", msg);
        if (code != 200) {
            log.log(LogLevel.INFO, "Returning response with response code " + code + ", error-code:" + errorType + ", message=" + msg);
        }
    }

    public static HttpErrorResponse notFoundError(String msg) {
        return new HttpErrorResponse(404, errorCodes.NOT_FOUND.name(), msg);
    }

    public static HttpErrorResponse internalServerError(String msg) {
        return new HttpErrorResponse(500, errorCodes.INTERNAL_SERVER_ERROR.name(), msg);
    }

    public static HttpErrorResponse invalidApplicationPackage(String msg) {
        return new HttpErrorResponse(400, errorCodes.INVALID_APPLICATION_PACKAGE.name(), msg);
    }

    public static HttpErrorResponse outOfCapacity(String msg) {
        return new HttpErrorResponse(400, errorCodes.OUT_OF_CAPACITY.name(), msg);
    }

    public static HttpErrorResponse badRequest(String msg) {
        return new HttpErrorResponse(400, errorCodes.BAD_REQUEST.name(), msg);
    }

    public static HttpErrorResponse conflictWhenActivating(String msg) {
        return new HttpErrorResponse(409, errorCodes.ACTIVATION_CONFLICT.name(), msg);
    }

    public static HttpErrorResponse methodNotAllowed(String msg) {
        return new HttpErrorResponse(405, errorCodes.METHOD_NOT_ALLOWED.name(), msg);
    }

    public static HttpResponse unknownVespaVersion(String message) {
        return new HttpErrorResponse(400, errorCodes.UNKNOWN_VESPA_VERSION.name(), message);
    }

    public static HttpResponse requestTimeout(String message) {
        return new HttpErrorResponse(408, errorCodes.REQUEST_TIMEOUT.name(), message);
    }

    public static HttpErrorResponse applicationLockFailure(String msg) {
        return new HttpErrorResponse(500, errorCodes.APPLICATION_LOCK_FAILURE.name(), msg);
    }

    public static HttpErrorResponse parentHostNotReady(String msg) {
        return new HttpErrorResponse(409, errorCodes.PARENT_HOST_NOT_READY.name(), msg);
    }

    public static HttpErrorResponse certificateNotReady(String msg) {
        return new HttpErrorResponse(409, errorCodes.CERTIFICATE_NOT_READY.name(), msg);
    }

    public void render(OutputStream stream) throws IOException {
        new JsonFormat(true).encode(stream, this.slime);
    }

    public String getContentType() {
        return "application/json";
    }

    public static enum errorCodes {
        APPLICATION_LOCK_FAILURE,
        BAD_REQUEST,
        ACTIVATION_CONFLICT,
        INTERNAL_SERVER_ERROR,
        INVALID_APPLICATION_PACKAGE,
        METHOD_NOT_ALLOWED,
        NOT_FOUND,
        OUT_OF_CAPACITY,
        REQUEST_TIMEOUT,
        UNKNOWN_VESPA_VERSION,
        PARENT_HOST_NOT_READY,
        CERTIFICATE_NOT_READY;

    }
}

