/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.serviceview;

import com.google.common.collect.ImmutableList;
import com.yahoo.vespa.serviceview.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;

public final class Cluster
implements Comparable<Cluster> {
    @NonNull
    public final String name;
    @NonNull
    public final String type;
    @NonNull
    public final ImmutableList<Service> services;

    public Cluster(String name, String type, List<Service> services) {
        this.name = name;
        this.type = type;
        ImmutableList.Builder builder = ImmutableList.builder();
        Object[] sortingBuffer = services.toArray(new Service[0]);
        Arrays.sort(sortingBuffer);
        builder.add(sortingBuffer);
        this.services = builder.build();
    }

    @Override
    public int compareTo(Cluster other) {
        int nameOrder = this.name.compareTo(other.name);
        if (nameOrder != 0) {
            return nameOrder;
        }
        return this.type.compareTo(other.type);
    }

    public int hashCode() {
        int prime = 761;
        int result = 1;
        result = 761 * result + this.name.hashCode();
        result = 761 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.type.equals(other.type);
    }

    public String toString() {
        int maxLen = 3;
        StringBuilder builder = new StringBuilder();
        builder.append("Cluster [name=").append(this.name).append(", type=").append(this.type).append(", services=").append(this.services.subList(0, Math.min(this.services.size(), 3))).append("]");
        return builder.toString();
    }
}

