/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.tenant.TenantHandlerProvider;
import com.yahoo.vespa.curator.Curator;
import java.time.Instant;
import java.util.Optional;
import org.apache.zookeeper.data.Stat;

public class Tenant
implements TenantHandlerProvider {
    static final String SESSIONS = "sessions";
    static final String APPLICATIONS = "applications";
    static final String LOCKS = "locks";
    private final TenantName name;
    private final RemoteSessionRepo remoteSessionRepo;
    private final Path path;
    private final SessionFactory sessionFactory;
    private final LocalSessionRepo localSessionRepo;
    private final TenantApplications applicationRepo;
    private final RequestHandler requestHandler;
    private final ReloadHandler reloadHandler;
    private final TenantFileSystemDirs tenantFileSystemDirs;
    private final Curator curator;

    Tenant(TenantName name, Path path, SessionFactory sessionFactory, LocalSessionRepo localSessionRepo, RemoteSessionRepo remoteSessionRepo, RequestHandler requestHandler, ReloadHandler reloadHandler, TenantApplications applicationRepo, Curator curator, TenantFileSystemDirs tenantFileSystemDirs) {
        this.name = name;
        this.path = path;
        this.requestHandler = requestHandler;
        this.reloadHandler = reloadHandler;
        this.remoteSessionRepo = remoteSessionRepo;
        this.sessionFactory = sessionFactory;
        this.localSessionRepo = localSessionRepo;
        this.applicationRepo = applicationRepo;
        this.tenantFileSystemDirs = tenantFileSystemDirs;
        this.curator = curator;
    }

    @Override
    public ReloadHandler getReloadHandler() {
        return this.reloadHandler;
    }

    @Override
    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public RemoteSessionRepo getRemoteSessionRepo() {
        return this.remoteSessionRepo;
    }

    public TenantName getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public LocalSessionRepo getLocalSessionRepo() {
        return this.localSessionRepo;
    }

    public String toString() {
        return this.getName().value();
    }

    public TenantApplications getApplicationRepo() {
        return this.applicationRepo;
    }

    public Curator getCurator() {
        return this.curator;
    }

    public Instant getCreatedTime() {
        Optional stat = this.curator.getStat(this.path);
        if (stat.isPresent()) {
            return Instant.ofEpochMilli(((Stat)stat.get()).getCtime());
        }
        return Instant.now();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Tenant)) {
            return false;
        }
        Tenant that = (Tenant)other;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    void close() {
        this.tenantFileSystemDirs.delete();
        this.remoteSessionRepo.close();
        this.applicationRepo.close();
        this.localSessionRepo.deleteAllSessions();
    }

    void delete() {
        this.curator.delete(this.path);
    }
}

