/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.container.jdisc.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class LogRetriever {
    private final HttpClient httpClient = HttpClientBuilder.create().build();

    public HttpResponse getLogs(String logServerHostname) {
        HttpGet get = new HttpGet(logServerHostname);
        try {
            return new ProxyResponse(this.httpClient.execute((HttpUriRequest)get));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class ProxyResponse
    extends HttpResponse {
        private final org.apache.http.HttpResponse clientResponse;

        private ProxyResponse(org.apache.http.HttpResponse clientResponse) {
            super(clientResponse.getStatusLine().getStatusCode());
            this.clientResponse = clientResponse;
        }

        public String getContentType() {
            return Optional.ofNullable(this.clientResponse.getFirstHeader("Content-Type")).map(Header::getValue).orElseGet(() -> super.getContentType());
        }

        public void render(OutputStream outputStream) throws IOException {
            this.clientResponse.getEntity().writeTo(outputStream);
        }
    }
}

