/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.path.Path;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import com.yahoo.vespa.config.server.tenant.ContainerEndpoint;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointSerializer;
import com.yahoo.vespa.curator.Curator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;

public class ContainerEndpointsCache {
    private final Path cachePath;
    private final Curator curator;

    public ContainerEndpointsCache(Path tenantPath, Curator curator) {
        this.cachePath = tenantPath.append("containerEndpointsCache/");
        this.curator = curator;
    }

    public List<ContainerEndpoint> read(ApplicationId applicationId) {
        Optional optionalData = this.curator.getData(this.applicationPath(applicationId));
        return optionalData.map(SlimeUtils::jsonToSlime).map(ContainerEndpointSerializer::endpointListFromSlime).orElseGet(List::of);
    }

    public void write(ApplicationId applicationId, List<ContainerEndpoint> endpoints) {
        if (endpoints.isEmpty()) {
            return;
        }
        Slime slime = ContainerEndpointSerializer.endpointListToSlime(endpoints);
        try {
            byte[] bytes = SlimeUtils.toJsonBytes((Slime)slime);
            this.curator.set(this.applicationPath(applicationId), bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error writing endpoints of: " + applicationId, e);
        }
    }

    private Path applicationPath(ApplicationId applicationId) {
        return this.cachePath.append(applicationId.serializedForm());
    }
}

