/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.vespa.applicationmodel.ClusterId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ContainerEndpoint {
    private final ClusterId clusterId;
    private final List<String> names;

    public ContainerEndpoint(ClusterId clusterId, List<String> names) {
        this.clusterId = Objects.requireNonNull(clusterId);
        this.names = List.copyOf((Collection)Objects.requireNonNull(names));
    }

    public ClusterId clusterId() {
        return this.clusterId;
    }

    public List<String> names() {
        return this.names;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerEndpoint that = (ContainerEndpoint)o;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.names, that.names);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.names);
    }

    public String toString() {
        return String.format("container endpoint %s -> %s", this.clusterId, this.names);
    }
}

