/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.curator.Curator;

public class RemoteSessionFactory {
    private final GlobalComponentRegistry componentRegistry;
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final Path sessionsPath;
    private final TenantName tenant;
    private final ConfigserverConfig configserverConfig;

    public RemoteSessionFactory(GlobalComponentRegistry componentRegistry, TenantName tenant) {
        this.componentRegistry = componentRegistry;
        this.curator = componentRegistry.getCurator();
        this.configCurator = componentRegistry.getConfigCurator();
        this.sessionsPath = TenantRepository.getSessionsPath(tenant);
        this.tenant = tenant;
        this.configserverConfig = componentRegistry.getConfigserverConfig();
    }

    public RemoteSession createSession(long sessionId) {
        Path sessionPath = this.sessionsPath.append(String.valueOf(sessionId));
        SessionZooKeeperClient sessionZKClient = new SessionZooKeeperClient(this.curator, this.configCurator, sessionPath, this.configserverConfig.serverId(), this.componentRegistry.getZone().nodeFlavors());
        return new RemoteSession(this.tenant, sessionId, this.componentRegistry, sessionZKClient);
    }
}

