/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.path.Path;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.request.HttpConfigRequests;
import com.yahoo.vespa.config.server.http.v2.request.HttpListConfigsRequest;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class HttpListConfigsHandler
extends HttpHandler {
    private final TenantRepository tenantRepository;
    private final Zone zone;

    @Inject
    public HttpListConfigsHandler(LoggingRequestHandler.Context ctx, TenantRepository tenantRepository, Zone zone) {
        super(ctx);
        this.tenantRepository = tenantRepository;
        this.zone = zone;
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        HttpListConfigsRequest listReq = HttpListConfigsRequest.createFromListRequest(req);
        RequestHandler requestHandler = HttpConfigRequests.getRequestHandler(this.tenantRepository, listReq);
        ApplicationId appId = listReq.getApplicationId();
        Set<ConfigKey<?>> configs = requestHandler.listConfigs(appId, Optional.empty(), listReq.isRecursive());
        String urlBase = HttpListConfigsHandler.getUrlBase(req, listReq, appId, this.zone);
        Set<ConfigKey<?>> allConfigs = requestHandler.allConfigsProduced(appId, Optional.empty());
        return new ListConfigsResponse(configs, allConfigs, urlBase, listReq.isRecursive());
    }

    static String getUrlBase(HttpRequest req, HttpListConfigsRequest listReq, ApplicationId appId, Zone zone) {
        if (listReq.isFullAppId()) {
            return Utils.getUrlBase(req, Path.fromString((String)"/config/v2/tenant/").append(appId.tenant().value()).append("application").append(appId.application().value()).append("environment").append(zone.environment().value()).append("region").append(zone.region().value()).append("instance").append(appId.instance().value()).getAbsolute() + "/");
        }
        return Utils.getUrlBase(req, Path.fromString((String)"/config/v2/tenant/").append(appId.tenant().value()).append("application").append(appId.application().value()).getAbsolute() + "/");
    }

    static class ListConfigsResponse
    extends HttpResponse {
        private final List<ConfigKey<?>> configs;
        private final Set<ConfigKey<?>> allConfigs;
        private final String urlBase;
        private final boolean recursive;

        public ListConfigsResponse(Set<ConfigKey<?>> configs, Set<ConfigKey<?>> allConfigs, String urlBase, boolean recursive) {
            super(200);
            this.configs = new ArrayList(configs);
            Collections.sort(this.configs);
            this.allConfigs = allConfigs;
            this.urlBase = urlBase;
            this.recursive = recursive;
        }

        public String toUrl(ConfigKey<?> key, boolean rec) {
            return this.urlBase + key.getNamespace() + "." + key.getName() + this.configIdUrlPart(rec, key.getConfigId());
        }

        private String configIdUrlPart(boolean rec, String configId) {
            if ("".equals(configId)) {
                return "";
            }
            if (rec) {
                return "/" + configId;
            }
            return "/" + configId + "/";
        }

        public void render(OutputStream outputStream) throws IOException {
            Cursor array;
            Slime slime = new Slime();
            Cursor root = slime.setObject();
            if (!this.recursive) {
                array = root.setArray("children");
                for (ConfigKey<?> key : ListConfigsResponse.keysThatHaveAChildWithSameName(this.configs, this.allConfigs)) {
                    array.addString(this.toUrl(key, false));
                }
            }
            array = root.setArray("configs");
            Collection<ConfigKey<?>> cfs = this.recursive ? this.configs : ListConfigsResponse.withParentConfigId(this.configs);
            for (ConfigKey<?> key : cfs) {
                array.addString(this.toUrl(key, true));
            }
            new JsonFormat(true).encode(outputStream, slime);
        }

        public static Set<ConfigKey<?>> keysThatHaveAChildWithSameName(Collection<ConfigKey<?>> keys, Set<ConfigKey<?>> allConfigs) {
            LinkedHashSet ret = new LinkedHashSet();
            for (ConfigKey<?> k : keys) {
                if (!ListConfigsResponse.hasAChild(k, allConfigs)) continue;
                ret.add(k);
            }
            return ret;
        }

        private static Set<ConfigKey<?>> withParentConfigId(Collection<ConfigKey<?>> keys) {
            LinkedHashSet ret = new LinkedHashSet();
            for (ConfigKey<?> k : keys) {
                ret.add(new ConfigKey(k.getName(), ListConfigsResponse.parentConfigId(k.getConfigId()), k.getNamespace()));
            }
            return ret;
        }

        static String parentConfigId(String id) {
            if (id == null) {
                return null;
            }
            if (!id.contains("/")) {
                return "";
            }
            return id.substring(0, id.lastIndexOf(47));
        }

        static boolean hasAChild(ConfigKey<?> key, Set<ConfigKey<?>> keys) {
            if ("".equals(key.getConfigId())) {
                return false;
            }
            for (ConfigKey<?> k : keys) {
                if (!k.getName().equals(key.getName()) || "".equals(k.getConfigId()) || k.getConfigId().equals(key.getConfigId()) || !k.getConfigId().startsWith(key.getConfigId())) continue;
                return true;
            }
            return false;
        }

        public String getContentType() {
            return "application/json";
        }
    }
}

