/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.StaticConfigDefinitionRepo;
import com.yahoo.vespa.config.server.UserConfigDefinitionRepo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ServerCache {
    private final ConfigDefinitionRepo builtinConfigDefinitions;
    private final ConfigDefinitionRepo userConfigDefinitions;
    private final Map<ConfigCacheKey, String> md5Sums = new ConcurrentHashMap<ConfigCacheKey, String>();
    private final Map<String, ConfigResponse> md5ToConfig = new ConcurrentHashMap<String, ConfigResponse>();
    private final Object[] stripedLocks = new Object[113];

    public ServerCache(ConfigDefinitionRepo builtinConfigDefinitions, ConfigDefinitionRepo userConfigDefinitions) {
        this.builtinConfigDefinitions = builtinConfigDefinitions;
        this.userConfigDefinitions = userConfigDefinitions;
        for (int i = 0; i < this.stripedLocks.length; ++i) {
            this.stripedLocks[i] = new Object();
        }
    }

    public ServerCache() {
        this(new StaticConfigDefinitionRepo(), new UserConfigDefinitionRepo());
    }

    private void put(ConfigCacheKey key, ConfigResponse config) {
        String configMd5 = config.getConfigMd5();
        this.md5Sums.put(key, configMd5);
        this.md5ToConfig.put(configMd5, config);
    }

    ConfigResponse get(ConfigCacheKey key) {
        String md5 = this.md5Sums.get(key);
        if (md5 == null) {
            return null;
        }
        return this.md5ToConfig.get(md5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigResponse computeIfAbsent(ConfigCacheKey key, Function<ConfigCacheKey, ConfigResponse> mappingFunction) {
        ConfigResponse config = this.get(key);
        if (config != null) {
            return config;
        }
        Object object = this.stripedLocks[Math.abs(key.hashCode() % this.stripedLocks.length)];
        synchronized (object) {
            String md5 = this.md5Sums.get(key);
            if (md5 == null) {
                config = mappingFunction.apply(key);
                this.put(key, config);
                return config;
            }
            return this.md5ToConfig.get(md5);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cache\n");
        sb.append("builtin defs: ").append(this.builtinConfigDefinitions.getConfigDefinitions().size()).append("\n");
        sb.append("user defs:    ").append(this.userConfigDefinitions.getConfigDefinitions().size()).append("\n");
        sb.append("md5sums:      ").append(this.md5Sums.size()).append("\n");
        sb.append("md5ToConfig:  ").append(this.md5ToConfig.size()).append("\n");
        return sb.toString();
    }

    public ConfigDefinition getDef(ConfigDefinitionKey defKey) {
        ConfigDefinition def = this.userConfigDefinitions.get(defKey);
        return def != null ? def : (ConfigDefinition)this.builtinConfigDefinitions.getConfigDefinitions().get(defKey);
    }

    public int configElems() {
        return this.md5ToConfig.size();
    }

    public int checkSumElems() {
        return this.md5Sums.size();
    }
}

