/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.google.common.base.Joiner;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.serialization.AllocatedHostsSerializer;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionProvider;
import com.yahoo.vespa.config.server.zookeeper.ZKApplication;
import com.yahoo.vespa.config.server.zookeeper.ZKApplicationFile;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.vespa.curator.Curator;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ZKApplicationPackage
implements ApplicationPackage {
    private final ZKApplication zkApplication;
    private final Map<Version, FileRegistry> fileRegistryMap = new HashMap<Version, FileRegistry>();
    private final Optional<AllocatedHosts> allocatedHosts;
    public static final String fileRegistryNode = "fileregistry";
    public static final String allocatedHostsNode = "allocatedHosts";
    private final ApplicationMetaData metaData;

    public ZKApplicationPackage(FileDistributionProvider fileDistributionProvider, Curator curator, Path sessionPath, int maxNodeSize) {
        ZKApplicationPackage.verifyAppPath(curator, sessionPath);
        this.zkApplication = new ZKApplication(curator, sessionPath, maxNodeSize);
        this.metaData = this.readMetaDataFromLiveApp(this.zkApplication);
        this.importFileRegistries(fileDistributionProvider);
        this.allocatedHosts = this.importAllocatedHosts();
    }

    ZKApplicationPackage(FileDistributionProvider fileDistributionProvider, Curator curator, Path sessionPath) {
        this(fileDistributionProvider, curator, sessionPath, 0xA00000);
    }

    private Optional<AllocatedHosts> importAllocatedHosts() {
        if (!this.zkApplication.exists(Path.fromString((String)allocatedHostsNode))) {
            return Optional.empty();
        }
        return Optional.of(this.readAllocatedHosts());
    }

    private AllocatedHosts readAllocatedHosts() {
        try {
            return AllocatedHostsSerializer.fromJson((byte[])this.zkApplication.getBytes(Path.fromString((String)allocatedHostsNode)));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read allocated hosts", e);
        }
    }

    private void importFileRegistries(FileDistributionProvider fileDistributionProvider) {
        List<String> perVersionFileRegistryNodes = this.zkApplication.getChildren(Path.fromString((String)fileRegistryNode));
        perVersionFileRegistryNodes.forEach(version -> this.fileRegistryMap.put(Version.fromString((String)version), this.importFileRegistry(fileDistributionProvider, Joiner.on((String)"/").join((Object)fileRegistryNode, version, new Object[0]))));
    }

    private FileRegistry importFileRegistry(FileDistributionProvider fileDistributionProvider, String fileRegistryNode) {
        try {
            return fileDistributionProvider.createPregeneratedFileRegistry(this.zkApplication.getDataReader(Path.fromString((String)fileRegistryNode)));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine which files to distribute", e);
        }
    }

    private ApplicationMetaData readMetaDataFromLiveApp(ZKApplication liveApp) {
        Path metaPath = Path.fromString((String)"/meta");
        String metaDataString = liveApp.getData(metaPath);
        if (metaDataString == null || metaDataString.isEmpty()) {
            return null;
        }
        return ApplicationMetaData.fromJsonString((String)liveApp.getData(metaPath));
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    private static void verifyAppPath(Curator zk, Path appPath) {
        if (!zk.exists(appPath)) {
            throw new RuntimeException("App with path " + appPath + " does not exist");
        }
    }

    public String getApplicationName() {
        return this.metaData.getApplicationId().application().value();
    }

    public ApplicationId getApplicationId() {
        return this.metaData.getApplicationId();
    }

    public Reader getServices() {
        return this.getUserAppData("services.xml");
    }

    public Reader getHosts() {
        if (this.zkApplication.exists(Path.fromString((String)"/userapp").append("hosts.xml"))) {
            return this.getUserAppData("hosts.xml");
        }
        return null;
    }

    public List<NamedReader> getSchemas() {
        ArrayList<NamedReader> schemas = new ArrayList<NamedReader>();
        for (String sd : this.zkApplication.getChildren(Path.fromString((String)"/userapp").append(SCHEMAS_DIR))) {
            if (!sd.endsWith(".sd")) continue;
            schemas.add(this.zkApplication.getNamedReader(sd, Path.fromString((String)"/userapp").append(SCHEMAS_DIR).append(sd)));
        }
        return schemas;
    }

    public Optional<AllocatedHosts> getAllocatedHosts() {
        return this.allocatedHosts;
    }

    public Map<Version, FileRegistry> getFileRegistries() {
        return Collections.unmodifiableMap(this.fileRegistryMap);
    }

    private Optional<FileRegistry> getFileRegistry(Version vespaVersion) {
        Optional<FileRegistry> fileRegistry = Optional.ofNullable(this.fileRegistryMap.get(vespaVersion));
        if (fileRegistry.isEmpty()) {
            fileRegistry = Optional.of(this.fileRegistryMap.values().iterator().next());
        }
        return fileRegistry;
    }

    private Reader retrieveConfigDefReader(String def) {
        try {
            return this.zkApplication.getNamedReader("configdefinition", Path.fromString((String)"/defconfigs").append(def));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not retrieve config definition " + def, e);
        }
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> ret = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        List<String> allDefs = this.zkApplication.getChildren(Path.fromString((String)"/defconfigs"));
        for (final String nodeName : allDefs) {
            final ConfigDefinitionKey key = ConfigUtils.createConfigDefinitionKeyFromZKString((String)nodeName);
            ret.put(key, new UnparsedConfigDefinition(){

                public ConfigDefinition parse() {
                    DefParser parser = new DefParser(key.getName(), ZKApplicationPackage.this.retrieveConfigDefReader(nodeName));
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                }

                public String getUnparsedContent() {
                    try {
                        return IOUtils.readAll((Reader)ZKApplicationPackage.this.retrieveConfigDefReader(nodeName));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error retriving def file", e);
                    }
                }
            });
        }
        return ret;
    }

    public List<NamedReader> getFiles(Path relativePath, String suffix, boolean recurse) {
        return this.zkApplication.getAllDataFromDirectory(Path.fromString((String)"/userapp").append(relativePath), suffix, recurse);
    }

    public ApplicationFile getFile(Path file) {
        return new ZKApplicationFile(file, this.zkApplication);
    }

    public String getHostSource() {
        return "zookeeper hosts file";
    }

    public String getServicesSource() {
        return "zookeeper services file";
    }

    public Optional<Reader> getDeployment() {
        return this.optionalFile(DEPLOYMENT_FILE.getName());
    }

    public Optional<Reader> getValidationOverrides() {
        return this.optionalFile(VALIDATION_OVERRIDES.getName());
    }

    private Optional<Reader> optionalFile(String file) {
        if (this.zkApplication.exists(Path.fromString((String)"/userapp").append(file))) {
            return Optional.of(this.getUserAppData(file));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getPaths(FileRegistry fileRegistry) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        FileRegistry fileRegistry2 = fileRegistry;
        synchronized (fileRegistry2) {
            for (FileRegistry.Entry e : fileRegistry.export()) {
                paths.add(e.relativePath);
            }
        }
        return paths;
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        FileRegistry fileRegistry = this.getFileRegistry(vespaVersion).get();
        for (String path : ZKApplicationPackage.getPaths(fileRegistry)) {
            if (!path.startsWith("components" + File.separator) || !path.endsWith(".jar")) continue;
            ComponentInfo component = new ComponentInfo(path);
            components.add(component);
        }
        return components;
    }

    private Reader getUserAppData(String node) {
        return this.zkApplication.getDataReader(Path.fromString((String)"/userapp").append(node));
    }

    public Reader getRankingExpression(String name) {
        return this.zkApplication.getDataReader(Path.fromString((String)"/userapp").append(SCHEMAS_DIR).append(name));
    }

    public File getFileReference(Path pathRelativeToAppDir) {
        Path path = Path.fromString((String)"/userapp").append(pathRelativeToAppDir);
        if (!this.zkApplication.exists(path)) {
            return new File(pathRelativeToAppDir.getRelative());
        }
        return new File(this.zkApplication.getData(path));
    }

    public void validateIncludeDir(String dirName) {
        Path path = Path.fromString((String)"/userapp").append(dirName);
        if (!this.zkApplication.exists(path)) {
            throw new IllegalArgumentException("Cannot include directory '" + dirName + "', as it does not exist in ZooKeeper!");
        }
    }
}

