/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.collections.Pair;
import com.yahoo.component.Version;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.model.api.ApplicationInfo;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.text.AbstractUtf8Array;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.config.GenericConfig;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.server.ServerCache;
import com.yahoo.vespa.config.server.UnknownConfigDefinitionException;
import com.yahoo.vespa.config.server.application.ConfigInstanceBuilder;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.rpc.UncompressedConfigResponseFactory;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.yolean.Exceptions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Application
implements ModelResult {
    private static final Logger log = Logger.getLogger(Application.class.getName());
    private final long applicationGeneration;
    private final Version vespaVersion;
    private final Model model;
    private final ServerCache cache;
    private final MetricUpdater metricUpdater;
    private final ApplicationId app;

    public Application(Model model, ServerCache cache, long applicationGeneration, Version vespaVersion, MetricUpdater metricUpdater, ApplicationId app) {
        Objects.requireNonNull(model, "The model cannot be null");
        this.model = model;
        this.cache = cache;
        this.applicationGeneration = applicationGeneration;
        this.vespaVersion = vespaVersion;
        this.metricUpdater = metricUpdater;
        this.app = app;
    }

    public Long getApplicationGeneration() {
        return this.applicationGeneration;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("application '").append(this.app.application().value()).append("', ");
        sb.append("generation ").append(this.applicationGeneration).append(", ");
        sb.append("vespa version ").append(this.vespaVersion);
        return sb.toString();
    }

    public ApplicationInfo toApplicationInfo() {
        return new ApplicationInfo(this.app, this.applicationGeneration, this.model);
    }

    public ServerCache getCache() {
        return this.cache;
    }

    public ApplicationId getId() {
        return this.app;
    }

    public Version getVespaVersion() {
        return this.vespaVersion;
    }

    public ConfigResponse resolveConfig(GetConfigRequest req, ConfigResponseFactory responseFactory) {
        ConfigResponse config;
        long start = System.currentTimeMillis();
        this.metricUpdater.incrementRequests();
        ConfigKey configKey = req.getConfigKey();
        String defMd5 = configKey.getMd5();
        if (defMd5 == null || defMd5.isEmpty()) {
            defMd5 = ConfigUtils.getDefMd5((List)req.getDefContent().asList());
        }
        ConfigCacheKey cacheKey = new ConfigCacheKey(configKey, defMd5);
        log.log(Level.FINE, () -> TenantRepository.logPre(this.getId()) + "Resolving config " + cacheKey);
        if (this.useCache(req) && (config = this.cache.get(cacheKey)) != null) {
            log.log(Level.FINE, () -> TenantRepository.logPre(this.getId()) + "Found config " + cacheKey + " in cache");
            this.metricUpdater.incrementProcTime(System.currentTimeMillis() - start);
            return config;
        }
        ConfigDefinition def = this.getTargetDef(req);
        if (def == null) {
            this.metricUpdater.incrementFailedRequests();
            throw new UnknownConfigDefinitionException("Unable to find config definition for '" + configKey.getNamespace() + "." + configKey.getName());
        }
        log.log(Level.FINE, () -> TenantRepository.logPre(this.getId()) + "Resolving " + configKey + " with config definition " + def);
        Pair<AbstractUtf8Array, Boolean> payload = this.createPayload(configKey, def);
        ConfigResponse configResponse = responseFactory.createResponse((AbstractUtf8Array)payload.getFirst(), this.applicationGeneration, (Boolean)payload.getSecond());
        this.metricUpdater.incrementProcTime(System.currentTimeMillis() - start);
        if (this.useCache(req)) {
            this.cache.put(cacheKey, configResponse, configResponse.getConfigMd5());
            this.metricUpdater.setCacheConfigElems(this.cache.configElems());
            this.metricUpdater.setCacheChecksumElems(this.cache.checkSumElems());
        }
        return configResponse;
    }

    private Pair<AbstractUtf8Array, Boolean> createPayload(ConfigKey<?> configKey, ConfigDefinition def) {
        try {
            ConfigPayload payload;
            ConfigInstance.Builder builder = this.model.getConfigInstance(configKey, def);
            boolean tempApplyOnRestart = builder.getApplyOnRestart();
            if (builder instanceof GenericConfig.GenericConfigBuilder) {
                return new Pair((Object)((GenericConfig.GenericConfigBuilder)builder).getPayload().toUtf8Array(true), (Object)tempApplyOnRestart);
            }
            String cacheBuilderClassNameForErrorReport = builder.getClass().getName();
            boolean applyOnRestart = false;
            try {
                ConfigInstance instance = ConfigInstanceBuilder.buildInstance(builder, def.getCNode());
                payload = ConfigPayload.fromInstance((ConfigInstance)instance);
                applyOnRestart = tempApplyOnRestart;
            }
            catch (ConfigurationRuntimeException e) {
                log.log(Level.INFO, TenantRepository.logPre(this.getId()) + ": Error resolving instance for builder '" + cacheBuilderClassNameForErrorReport + "', returning empty config: " + Exceptions.toMessageString((Throwable)e));
                payload = ConfigPayload.fromBuilder((ConfigPayloadBuilder)new ConfigPayloadBuilder());
            }
            if (def.getCNode() != null) {
                payload.applyDefaultsFromDef(def.getCNode());
            }
            return new Pair((Object)payload.toUtf8Array(true), (Object)applyOnRestart);
        }
        catch (Exception e) {
            throw new ConfigurationRuntimeException("Unable to get config for " + this.app, (Throwable)e);
        }
    }

    private boolean useCache(GetConfigRequest request) {
        return !request.noCache();
    }

    private ConfigDefinition getTargetDef(GetConfigRequest req) {
        ConfigKey configKey = req.getConfigKey();
        DefContent def = req.getDefContent();
        ConfigDefinitionKey configDefinitionKey = new ConfigDefinitionKey(configKey.getName(), configKey.getNamespace());
        if (def.isEmpty()) {
            log.log(Level.FINE, () -> TenantRepository.logPre(this.getId()) + "No config schema in request for " + configKey);
            return this.cache.getDef(configDefinitionKey);
        }
        log.log(Level.FINE, () -> TenantRepository.logPre(this.getId()) + "Got config schema from request, length:" + def.asList().size() + " : " + configKey);
        return new ConfigDefinition(configKey.getName(), def.asStringArray());
    }

    void updateHostMetrics(int numHosts) {
        this.metricUpdater.setHosts(numHosts);
    }

    ConfigResponse resolveConfig(GetConfigRequest req) {
        return this.resolveConfig(req, new UncompressedConfigResponseFactory());
    }

    public Set<ConfigKey<?>> allConfigsProduced() {
        return this.model.allConfigsProduced();
    }

    public Set<String> allConfigIds() {
        return this.model.allConfigIds();
    }
}

