/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.OutOfCapacityException;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.Zone;
import com.yahoo.lang.SettableOptional;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.provision.ProvisionerAdapter;
import com.yahoo.vespa.config.server.provision.StaticProvisioner;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ModelsBuilder<MODELRESULT extends ModelResult> {
    private static final Logger log = Logger.getLogger(ModelsBuilder.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    protected final ConfigserverConfig configserverConfig;
    private final boolean hosted;
    private final Zone zone;
    private final HostProvisionerProvider hostProvisionerProvider;

    ModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, ConfigserverConfig configserverConfig, Zone zone, HostProvisionerProvider hostProvisionerProvider) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.configserverConfig = configserverConfig;
        this.hosted = configserverConfig.hostedVespa();
        this.zone = zone;
        this.hostProvisionerProvider = hostProvisionerProvider;
    }

    protected Zone zone() {
        return this.zone;
    }

    public List<MODELRESULT> buildModels(ApplicationId applicationId, Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, SettableOptional<AllocatedHosts> allocatedHosts, Instant now) {
        log.log((Level)LogLevel.DEBUG, "Will build models for " + applicationId);
        Set<Version> versions = this.modelFactoryRegistry.allVersions();
        Optional requestedMajorVersion = applicationPackage.getMajorVersion();
        if (requestedMajorVersion.isPresent() && (versions = this.keepUpToMajorVersion((Integer)requestedMajorVersion.get(), versions)).isEmpty()) {
            throw new UnknownVespaVersionException("No Vespa versions on or before major version " + requestedMajorVersion.get() + " are present");
        }
        List majorVersions = versions.stream().map(Version::getMajor).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        ArrayList<MODELRESULT> allApplicationModels = new ArrayList<MODELRESULT>();
        boolean buildLatestModelForThisMajor = true;
        for (int i = 0; i < majorVersions.size(); ++i) {
            int majorVersion = (Integer)majorVersions.get(i);
            try {
                allApplicationModels.addAll(this.buildModelVersions(this.keepMajorVersion(majorVersion, versions), applicationId, wantedNodeVespaVersion, applicationPackage, allocatedHosts, now, buildLatestModelForThisMajor, majorVersion));
                if (allApplicationModels.size() > 0 && ((ModelResult)allApplicationModels.get(0)).getModel().skipOldConfigModels(now)) break;
                buildLatestModelForThisMajor = false;
                continue;
            }
            catch (ApplicationLockException | OutOfCapacityException e) {
                throw e;
            }
            catch (RuntimeException e) {
                boolean isOldestMajor;
                boolean bl = isOldestMajor = i == majorVersions.size() - 1;
                if (isOldestMajor) {
                    if (e instanceof NullPointerException || e instanceof NoSuchElementException | e instanceof UncheckedTimeoutException) {
                        log.log(LogLevel.WARNING, "Unexpected error when building model ", e);
                        throw new InternalServerException(applicationId + ": Error loading model", e);
                    }
                    log.log(LogLevel.WARNING, "Input error when building model ", e);
                    throw new IllegalArgumentException(applicationId + ": Error loading model", e);
                }
                log.log(LogLevel.INFO, applicationId + ": Skipping major version " + majorVersions.get(i), e);
            }
        }
        log.log((Level)LogLevel.DEBUG, "Done building models for " + applicationId);
        return allApplicationModels;
    }

    private List<MODELRESULT> buildModelVersions(Set<Version> versions, ApplicationId applicationId, Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, SettableOptional<AllocatedHosts> allocatedHosts, Instant now, boolean buildLatestModelForThisMajor, int majorVersion) {
        ArrayList<MODELRESULT> allApplicationVersions = new ArrayList<MODELRESULT>();
        Optional<Object> latest = Optional.empty();
        if (buildLatestModelForThisMajor) {
            latest = Optional.of(this.findLatest(versions));
            MODELRESULT latestModelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory((Version)latest.get()), applicationPackage, applicationId, wantedNodeVespaVersion, allocatedHosts.asOptional(), now);
            allocatedHosts.set((Object)latestModelVersion.getModel().allocatedHosts());
            allApplicationVersions.add(latestModelVersion);
            if (latestModelVersion.getModel().skipOldConfigModels(now)) {
                return allApplicationVersions;
            }
        }
        versions = this.versionsToBuild(versions, wantedNodeVespaVersion, majorVersion, (AllocatedHosts)allocatedHosts.get());
        for (Version version : versions) {
            if (latest.isPresent() && version.equals(latest.get())) continue;
            MODELRESULT modelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory(version), applicationPackage, applicationId, wantedNodeVespaVersion, allocatedHosts.asOptional(), now);
            allocatedHosts.set((Object)modelVersion.getModel().allocatedHosts());
            allApplicationVersions.add(modelVersion);
        }
        return allApplicationVersions;
    }

    private Set<Version> versionsToBuild(Set<Version> versions, Version wantedVersion, int majorVersion, AllocatedHosts allocatedHosts) {
        if (this.configserverConfig.buildMinimalSetOfConfigModels()) {
            versions = this.keepThoseUsedOn(allocatedHosts, versions);
        }
        if (this.hosted && wantedVersion.getMajor() == majorVersion) {
            versions.add(wantedVersion);
        }
        return versions;
    }

    private Set<Version> keepMajorVersion(int majorVersion, Set<Version> versions) {
        return versions.stream().filter(v -> v.getMajor() == majorVersion).collect(Collectors.toSet());
    }

    private Set<Version> keepUpToMajorVersion(int majorVersion, Set<Version> versions) {
        return versions.stream().filter(v -> v.getMajor() <= majorVersion).collect(Collectors.toSet());
    }

    private Version findLatest(Set<Version> versionSet) {
        ArrayList<Version> versionList = new ArrayList<Version>(versionSet);
        Collections.sort(versionList);
        return (Version)versionList.get(versionList.size() - 1);
    }

    private Set<Version> keepThoseUsedOn(AllocatedHosts hosts, Set<Version> versions) {
        return versions.stream().filter(version -> this.isUsedOn(hosts, (Version)version)).collect(Collectors.toSet());
    }

    private boolean isUsedOn(AllocatedHosts hosts, Version version) {
        return hosts.getHosts().stream().anyMatch(host -> host.version().isPresent() && ((Version)host.version().get()).equals((Object)version));
    }

    protected abstract MODELRESULT buildModelVersion(ModelFactory var1, ApplicationPackage var2, ApplicationId var3, Version var4, Optional<AllocatedHosts> var5, Instant var6);

    Optional<HostProvisioner> createStaticProvisioner(Optional<AllocatedHosts> allocatedHosts, ModelContext.Properties properties) {
        if (this.hosted && allocatedHosts.isPresent()) {
            return Optional.of(new StaticProvisioner(allocatedHosts.get(), this.createNodeRepositoryProvisioner(properties).get()));
        }
        return Optional.empty();
    }

    Optional<HostProvisioner> createNodeRepositoryProvisioner(ModelContext.Properties properties) {
        return this.hostProvisionerProvider.getHostProvisioner().map(provisioner -> new ProvisionerAdapter((Provisioner)provisioner, properties.applicationId()));
    }
}

