/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.net.HostName;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.filedistribution.AddFileInterface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.jpountz.xxhash.XXHashFactory;

public class FileDBRegistry
implements FileRegistry {
    private final AddFileInterface manager;
    private final List<FileRegistry.Entry> entries = new ArrayList<FileRegistry.Entry>();
    private final Map<String, FileReference> fileReferenceCache = new HashMap<String, FileReference>();

    public FileDBRegistry(AddFileInterface manager) {
        this.manager = manager;
    }

    public synchronized FileReference addFile(String relativePath) {
        Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(relativePath));
        return cachedReference.orElseGet(() -> {
            FileReference newRef = this.manager.addFile(relativePath);
            this.entries.add(new FileRegistry.Entry(relativePath, newRef));
            this.fileReferenceCache.put(relativePath, newRef);
            return newRef;
        });
    }

    public synchronized FileReference addUri(String uri) {
        String relativePath = FileDBRegistry.uriToRelativeFile(uri);
        Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(uri));
        return cachedReference.orElseGet(() -> {
            FileReference newRef = this.manager.addUri(uri, relativePath);
            this.entries.add(new FileRegistry.Entry(uri, newRef));
            this.fileReferenceCache.put(uri, newRef);
            return newRef;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileReference addBlob(ByteBuffer blob) {
        long blobHash = XXHashFactory.fastestJavaInstance().hash64().hash(blob, 0L);
        String blobName = Long.toHexString(blobHash);
        String relativePath = FileDBRegistry.blobToRelativeFile(blob, blobName);
        FileDBRegistry fileDBRegistry = this;
        synchronized (fileDBRegistry) {
            Optional<FileReference> cachedReference = Optional.ofNullable(this.fileReferenceCache.get(blobName));
            return cachedReference.orElseGet(() -> {
                FileReference newRef = this.manager.addBlob(blob, relativePath);
                this.entries.add(new FileRegistry.Entry(blobName, newRef));
                this.fileReferenceCache.put(blobName, newRef);
                return newRef;
            });
        }
    }

    public String fileSourceHost() {
        return HostName.getLocalhost();
    }

    public synchronized List<FileRegistry.Entry> export() {
        return this.entries;
    }

    private static String uriToRelativeFile(String uri) {
        String relative = "uri/" + XXHashFactory.fastestJavaInstance().hash64().hash(ByteBuffer.wrap(Utf8.toBytes((String)uri)), 0L);
        if (uri.endsWith(".json")) {
            relative = relative + ".json";
        } else if (uri.endsWith(".json.lz4")) {
            relative = relative + ".json.lz4";
        } else if (uri.endsWith(".lz4")) {
            relative = relative + ".lz4";
        }
        return relative;
    }

    private static String blobToRelativeFile(ByteBuffer blob, String blobName) {
        String relative = "blob/" + blobName;
        return relative;
    }
}

