/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.TenantName;
import com.yahoo.lang.SettableOptional;
import com.yahoo.log.LogLevel;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.modelfactory.ActivatedModelsBuilder;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.KeeperException;

public class RemoteSession
extends Session {
    private static final Logger log = Logger.getLogger(RemoteSession.class.getName());
    private ApplicationSet applicationSet = null;
    private final ActivatedModelsBuilder applicationLoader;
    private final Clock clock;

    public RemoteSession(TenantName tenant, long sessionId, GlobalComponentRegistry componentRegistry, SessionZooKeeperClient zooKeeperClient) {
        super(tenant, sessionId, zooKeeperClient);
        this.applicationLoader = new ActivatedModelsBuilder(tenant, sessionId, zooKeeperClient, componentRegistry);
        this.clock = componentRegistry.getClock();
    }

    void loadPrepared() {
        Curator.CompletionWaiter waiter = this.zooKeeperClient.getPrepareWaiter();
        this.ensureApplicationLoaded();
        this.notifyCompletion(waiter);
    }

    private ApplicationSet loadApplication() {
        ApplicationPackage applicationPackage = this.zooKeeperClient.loadApplicationPackage();
        Optional allocatedHosts = applicationPackage.getAllocatedHosts();
        return ApplicationSet.fromList(this.applicationLoader.buildModels(this.zooKeeperClient.readApplicationId(), this.zooKeeperClient.readVespaVersion(), applicationPackage, (SettableOptional<AllocatedHosts>)new SettableOptional(allocatedHosts), this.clock.instant()));
    }

    public synchronized ApplicationSet ensureApplicationLoaded() {
        if (this.applicationSet == null) {
            this.applicationSet = this.loadApplication();
        }
        return this.applicationSet;
    }

    @Override
    public Session.Status getStatus() {
        return this.zooKeeperClient.readStatus();
    }

    public synchronized void deactivate() {
        this.applicationSet = null;
    }

    public Transaction createDeleteTransaction() {
        return this.zooKeeperClient.createWriteStatusTransaction(Session.Status.DELETE);
    }

    void makeActive(ReloadHandler reloadHandler) {
        Curator.CompletionWaiter waiter = this.zooKeeperClient.getActiveWaiter();
        log.log((Level)LogLevel.DEBUG, () -> this.logPre() + "Getting session from repo: " + this.getSessionId());
        ApplicationSet app = this.ensureApplicationLoaded();
        log.log((Level)LogLevel.DEBUG, () -> this.logPre() + "Reloading config for " + this.getSessionId());
        reloadHandler.reloadConfig(app);
        log.log((Level)LogLevel.DEBUG, () -> this.logPre() + "Notifying " + waiter);
        this.notifyCompletion(waiter);
        log.log(LogLevel.INFO, this.logPre() + "Session activated: " + this.getSessionId());
    }

    @Override
    public String logPre() {
        if (this.applicationSet != null) {
            return TenantRepository.logPre(this.applicationSet.getForVersionOrLatest(Optional.empty(), Instant.now()).getId());
        }
        return TenantRepository.logPre(this.getTenant());
    }

    void confirmUpload() {
        Curator.CompletionWaiter waiter = this.zooKeeperClient.getUploadWaiter();
        log.log((Level)LogLevel.DEBUG, "Notifying upload waiter for session " + this.getSessionId());
        this.notifyCompletion(waiter);
        log.log((Level)LogLevel.DEBUG, "Done notifying upload for session " + this.getSessionId());
    }

    private void notifyCompletion(Curator.CompletionWaiter completionWaiter) {
        try {
            completionWaiter.notifyCompletion();
        }
        catch (RuntimeException e) {
            if (e.getCause().getClass() != KeeperException.NoNodeException.class) {
                throw e;
            }
            log.log(LogLevel.INFO, "Not able to notify completion for session: " + this.getSessionId() + ", node has been deleted");
        }
    }

    public void delete() {
        CuratorTransaction transaction = this.zooKeeperClient.deleteTransaction();
        transaction.commit();
        transaction.close();
    }
}

