/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.path.Path;
import com.yahoo.transaction.AbstractTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.GenerationCounter;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.recipes.CuratorCounter;

public class SuperModelGenerationCounter
implements GenerationCounter {
    private static final Path counterPath = Path.fromString((String)"/config/v2/RPC/superModelGeneration");
    private final CuratorCounter counter;

    public SuperModelGenerationCounter(Curator curator) {
        this.counter = new CuratorCounter(curator, counterPath.getAbsolute());
    }

    public synchronized long increment() {
        return this.counter.next();
    }

    public synchronized long get() {
        return this.counter.get();
    }

    public IncrementTransaction incrementTransaction() {
        return new IncrementTransaction(this.counter);
    }

    public static class IncrementTransaction
    extends AbstractTransaction {
        public IncrementTransaction(CuratorCounter counter) {
            this.add(new IncrementOperation(counter));
        }

        public void prepare() {
        }

        public void commit() {
            for (Transaction.Operation operation : this.operations()) {
                ((IncrementOperation)operation).commit();
            }
        }

        public void rollbackOrLog() {
            for (Transaction.Operation operation : this.operations()) {
                ((IncrementOperation)operation).rollback();
            }
        }

        public static class IncrementOperation
        implements Transaction.Operation {
            private final CuratorCounter counter;

            public IncrementOperation(CuratorCounter counter) {
                this.counter = counter;
            }

            public void commit() {
                this.counter.next();
            }

            public void rollback() {
            }

            public String toString() {
                return "increment " + counterPath + " operation";
            }
        }
    }
}

