/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.RequestWaiter;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Value;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDistributionImpl
implements FileDistribution,
RequestWaiter {
    private static final Logger log = Logger.getLogger(FileDistributionImpl.class.getName());
    private static final double rpcTimeout = 1.0;
    private final Supervisor supervisor;
    private final File fileReferencesDir;

    public FileDistributionImpl(ConfigserverConfig configserverConfig, Supervisor supervisor) {
        this.fileReferencesDir = new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir()));
        this.supervisor = supervisor;
    }

    public void startDownload(String hostName, int port, Set<FileReference> fileReferences) {
        this.startDownloadingFileReferences(hostName, port, fileReferences);
    }

    public File getFileReferencesDir() {
        return this.fileReferencesDir;
    }

    private void startDownloadingFileReferences(String hostName, int port, Set<FileReference> fileReferences) {
        Target target = this.supervisor.connect(new Spec(hostName, port));
        Request request = new Request("filedistribution.setFileReferencesToDownload");
        request.setContext((Object)target);
        request.parameters().add((Value)new StringArray((String[])fileReferences.stream().map(FileReference::value).toArray(String[]::new)));
        log.log(Level.FINE, () -> "Executing " + request.methodName() + " against " + target);
        target.invokeAsync(request, 1.0, (RequestWaiter)this);
    }

    public void handleRequestDone(Request req) {
        Target target = (Target)req.getContext();
        if (req.isError()) {
            log.log(Level.FINE, () -> req.methodName() + " failed for " + target + ": " + req.errorCode() + " (" + req.errorMessage() + ")");
        }
        if (target != null) {
            target.close();
        }
    }
}

