/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.curator.Curator;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class SessionStateWatcher {
    private static final Logger log = Logger.getLogger(SessionStateWatcher.class.getName());
    private final Curator.FileCache fileCache;
    private volatile RemoteSession session;
    private final MetricUpdater metrics;
    private final Executor zkWatcherExecutor;
    private final SessionRepository sessionRepository;

    SessionStateWatcher(Curator.FileCache fileCache, RemoteSession session, MetricUpdater metrics, Executor zkWatcherExecutor, SessionRepository sessionRepository) {
        this.fileCache = fileCache;
        this.session = session;
        this.metrics = metrics;
        this.fileCache.addListener(this::nodeChanged);
        this.fileCache.start();
        this.zkWatcherExecutor = zkWatcherExecutor;
        this.sessionRepository = sessionRepository;
    }

    private synchronized void sessionStatusChanged(Session.Status newStatus) {
        long sessionId = this.session.getSessionId();
        switch (newStatus) {
            case NEW: 
            case NONE: {
                break;
            }
            case DELETE: {
                this.sessionRepository.deactivateAndUpdateCache(this.session);
                break;
            }
            case PREPARE: {
                this.createLocalSession(sessionId);
                this.sessionRepository.prepareRemoteSession(this.session);
                break;
            }
            case ACTIVATE: {
                this.createLocalSession(sessionId);
                this.sessionRepository.activate(this.session);
                break;
            }
            case DEACTIVATE: {
                this.sessionRepository.deactivateAndUpdateCache(this.session);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown status " + newStatus);
            }
        }
    }

    private void createLocalSession(long sessionId) {
        this.sessionRepository.createLocalSessionFromDistributedApplicationPackage(sessionId);
    }

    public long getSessionId() {
        return this.session.getSessionId();
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing watcher", e);
        }
    }

    private void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            Session.Status newStatus = Session.Status.NONE;
            try {
                ChildData node = this.fileCache.getCurrentData();
                if (node != null) {
                    newStatus = Session.Status.parse(Utf8.toString((byte[])node.getData()));
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, this.session.logPre() + "Session change: Session " + this.session.getSessionId() + " changed status to " + newStatus.name());
                    }
                    this.sessionStatusChanged(newStatus);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, this.session.logPre() + "Error handling session change to " + newStatus.name() + " for session " + this.getSessionId(), e);
                this.metrics.incSessionChangeErrors();
            }
        });
    }

    public synchronized void updateRemoteSession(RemoteSession session) {
        this.session = session;
    }
}

