/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.google.common.base.Joiner;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.model.application.provider.PreGeneratedFileRegistry;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.serialization.AllocatedHostsSerializer;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionBuilder;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.server.zookeeper.ZKApplication;
import com.yahoo.vespa.config.server.zookeeper.ZKApplicationFile;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ZKApplicationPackage
implements ApplicationPackage {
    private final ZKApplication zkApplication;
    private final Map<Version, PreGeneratedFileRegistry> fileRegistryMap = new HashMap<Version, PreGeneratedFileRegistry>();
    private final Optional<AllocatedHosts> allocatedHosts;
    public static final String fileRegistryNode = "fileregistry";
    public static final String allocatedHostsNode = "allocatedHosts";
    private final ApplicationMetaData metaData;

    public ZKApplicationPackage(ConfigCurator zk, Path sessionPath) {
        ZKApplicationPackage.verifyAppPath(zk, sessionPath);
        this.zkApplication = new ZKApplication(zk, sessionPath);
        this.metaData = this.readMetaDataFromLiveApp(this.zkApplication);
        this.importFileRegistries();
        this.allocatedHosts = this.importAllocatedHosts();
    }

    private Optional<AllocatedHosts> importAllocatedHosts() {
        if (!this.zkApplication.exists(allocatedHostsNode)) {
            return Optional.empty();
        }
        return Optional.of(this.readAllocatedHosts());
    }

    private AllocatedHosts readAllocatedHosts() {
        try {
            return AllocatedHostsSerializer.fromJson((byte[])this.zkApplication.getBytes(allocatedHostsNode));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read allocated hosts", e);
        }
    }

    private void importFileRegistries() {
        List<String> perVersionFileRegistryNodes = this.zkApplication.getChildren(fileRegistryNode);
        perVersionFileRegistryNodes.forEach(version -> this.fileRegistryMap.put(Version.fromString((String)version), this.importFileRegistry(Joiner.on((String)"/").join((Object)fileRegistryNode, version, new Object[0]))));
    }

    private PreGeneratedFileRegistry importFileRegistry(String fileRegistryNode) {
        try {
            return PreGeneratedFileRegistry.importRegistry((Reader)this.zkApplication.getDataReader(fileRegistryNode));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine which files to distribute", e);
        }
    }

    private ApplicationMetaData readMetaDataFromLiveApp(ZKApplication liveApp) {
        String metaDataString = liveApp.getData("/meta");
        if (metaDataString == null || metaDataString.isEmpty()) {
            return null;
        }
        return ApplicationMetaData.fromJsonString((String)liveApp.getData("/meta"));
    }

    public ApplicationMetaData getMetaData() {
        return this.metaData;
    }

    private static void verifyAppPath(ConfigCurator zk, Path appPath) {
        if (!zk.exists(appPath.getAbsolute())) {
            throw new RuntimeException("App with path " + appPath + " does not exist");
        }
    }

    public String getApplicationName() {
        return this.metaData.getApplicationId().application().value();
    }

    public ApplicationId getApplicationId() {
        return this.metaData.getApplicationId();
    }

    public Reader getServices() {
        return this.getUserAppData("services.xml");
    }

    public Reader getHosts() {
        if (this.zkApplication.exists("/userapp", "hosts.xml")) {
            return this.getUserAppData("hosts.xml");
        }
        return null;
    }

    public List<NamedReader> getSchemas() {
        ArrayList<NamedReader> schemas = new ArrayList<NamedReader>();
        for (String sd : this.zkApplication.getChildren("/userapp/" + SCHEMAS_DIR)) {
            if (!sd.endsWith(".sd")) continue;
            schemas.add(new NamedReader(sd, (Reader)new StringReader(this.zkApplication.getData("/userapp/" + SCHEMAS_DIR, sd))));
        }
        for (String sd : this.zkApplication.getChildren("/userapp/" + SEARCH_DEFINITIONS_DIR)) {
            if (!sd.endsWith(".sd")) continue;
            schemas.add(new NamedReader(sd, (Reader)new StringReader(this.zkApplication.getData("/userapp/" + SEARCH_DEFINITIONS_DIR, sd))));
        }
        return schemas;
    }

    public Optional<AllocatedHosts> getAllocatedHosts() {
        return this.allocatedHosts;
    }

    public Map<Version, FileRegistry> getFileRegistries() {
        return Collections.unmodifiableMap(this.fileRegistryMap);
    }

    private Optional<PreGeneratedFileRegistry> getPreGeneratedFileRegistry(Version vespaVersion) {
        Optional<PreGeneratedFileRegistry> fileRegistry = Optional.ofNullable(this.fileRegistryMap.get(vespaVersion));
        if (fileRegistry.isEmpty()) {
            fileRegistry = Optional.of(this.fileRegistryMap.values().iterator().next());
        }
        return fileRegistry;
    }

    private Reader retrieveConfigDefReader(String def) {
        try {
            return this.zkApplication.getDataReader("/defconfigs", def);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not retrieve config definition " + def, e);
        }
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition> ret = new LinkedHashMap<ConfigDefinitionKey, UnparsedConfigDefinition>();
        List<String> allDefs = this.zkApplication.getChildren("/defconfigs");
        for (final String nodeName : allDefs) {
            final ConfigDefinitionKey key = ConfigUtils.createConfigDefinitionKeyFromZKString((String)nodeName);
            ret.put(key, new UnparsedConfigDefinition(){

                public ConfigDefinition parse() {
                    DefParser parser = new DefParser(key.getName(), ZKApplicationPackage.this.retrieveConfigDefReader(nodeName));
                    return ConfigDefinitionBuilder.createConfigDefinition((CNode)parser.getTree());
                }

                public String getUnparsedContent() {
                    try {
                        return IOUtils.readAll((Reader)ZKApplicationPackage.this.retrieveConfigDefReader(nodeName));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error retriving def file", e);
                    }
                }
            });
        }
        return ret;
    }

    public List<NamedReader> getFiles(Path relativePath, String suffix, boolean recurse) {
        return this.zkApplication.getAllDataFromDirectory("/userapp/" + relativePath.getRelative(), suffix, recurse);
    }

    public ApplicationFile getFile(Path file) {
        return new ZKApplicationFile(file, this.zkApplication);
    }

    public String getHostSource() {
        return "zookeeper hosts file";
    }

    public String getServicesSource() {
        return "zookeeper services file";
    }

    public Optional<Reader> getDeployment() {
        return this.optionalFile(DEPLOYMENT_FILE.getName());
    }

    public Optional<Reader> getValidationOverrides() {
        return this.optionalFile(VALIDATION_OVERRIDES.getName());
    }

    private Optional<Reader> optionalFile(String file) {
        if (this.zkApplication.exists("/userapp", file)) {
            return Optional.of(this.getUserAppData(file));
        }
        return Optional.empty();
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        PreGeneratedFileRegistry fileRegistry = this.getPreGeneratedFileRegistry(vespaVersion).get();
        for (String path : fileRegistry.getPaths()) {
            if (!path.startsWith("components" + File.separator) || !path.endsWith(".jar")) continue;
            ComponentInfo component = new ComponentInfo(path);
            components.add(component);
        }
        return components;
    }

    private Reader getUserAppData(String node) {
        return this.zkApplication.getDataReader("/userapp", node);
    }

    public Reader getRankingExpression(String name) {
        Optional<Reader> reader = this.zkApplication.getOptionalDataReader("/userapp/" + SCHEMAS_DIR, name);
        return reader.orElseGet(() -> this.zkApplication.getDataReader("/userapp/" + SEARCH_DEFINITIONS_DIR, name));
    }

    public File getFileReference(Path pathRelativeToAppDir) {
        String fileName = this.zkApplication.getData("/userapp/" + pathRelativeToAppDir.getRelative());
        return new File(Objects.requireNonNullElseGet(fileName, () -> ((Path)pathRelativeToAppDir).getRelative()));
    }

    public void validateIncludeDir(String dirName) {
        String fullPath = "/userapp/" + dirName;
        if (!this.zkApplication.exists(fullPath)) {
            throw new IllegalArgumentException("Cannot include directory '" + dirName + "', as it does not exist in ZooKeeper!");
        }
    }
}

