/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.rpc.security;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.security.NodeIdentifier;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.security.tls.TransportSecurityUtils;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.rpc.RequestHandlerProvider;
import com.yahoo.vespa.config.server.rpc.security.MultiTenantRpcAuthorizer;
import com.yahoo.vespa.config.server.rpc.security.NoopRpcAuthorizer;
import com.yahoo.vespa.config.server.rpc.security.RpcAuthorizer;

public class DefaultRpcAuthorizerProvider
implements Provider<RpcAuthorizer> {
    private final RpcAuthorizer rpcAuthorizer;

    @Inject
    public DefaultRpcAuthorizerProvider(ConfigserverConfig config, NodeIdentifier nodeIdentifier, HostRegistry hostRegistry, RequestHandlerProvider handlerProvider) {
        boolean useMultiTenantAuthorizer = TransportSecurityUtils.isTransportSecurityEnabled() && config.multitenant() && config.hostedVespa();
        this.rpcAuthorizer = useMultiTenantAuthorizer ? new MultiTenantRpcAuthorizer(nodeIdentifier, hostRegistry, handlerProvider, DefaultRpcAuthorizerProvider.getThreadPoolSize(config)) : new NoopRpcAuthorizer();
    }

    private static int getThreadPoolSize(ConfigserverConfig config) {
        return config.numRpcThreads() != 0 ? config.numRpcThreads() : 8;
    }

    public RpcAuthorizer get() {
        return this.rpcAuthorizer;
    }

    public void deconstruct() {
    }
}

