/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.model.application.provider.PreGeneratedFileRegistry;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.serialization.AllocatedHostsSerializer;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ZooKeeperClient {
    private final ConfigCurator configCurator;
    private final DeployLogger logger;
    private final Path sessionPath;
    private static final ApplicationFile.PathFilter xmlFilter = path -> path.getName().endsWith(".xml");

    public ZooKeeperClient(ConfigCurator configCurator, DeployLogger logger, Path sessionPath) {
        this.configCurator = configCurator;
        this.logger = logger;
        this.sessionPath = sessionPath;
    }

    void initialize() {
        if (!this.configCurator.exists(this.sessionPath.getAbsolute())) {
            this.configCurator.createNode(this.sessionPath.getAbsolute());
        }
        for (String subPath : Arrays.asList("/defconfigs", "/userdefconfigs", "/userapp", "fileregistry")) {
            this.configCurator.createNode(this.getZooKeeperAppPath().getAbsolute(), subPath.replaceFirst("/", ""));
        }
    }

    void writeApplicationPackage(ApplicationPackage app) {
        try {
            this.writeUserDefs(app);
            this.writeSomeOf(app);
            this.writeSchemas(app);
            this.writeUserIncludeDirs(app, app.getUserIncludeDirs());
            this.writeMetadata(app.getMetaData());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to write vespa model to config server(s) " + System.getProperty("configsources") + "\nPlease ensure that config server is started and check the vespa log for configserver errors. ", e);
        }
    }

    private void writeSchemas(ApplicationPackage app) throws IOException {
        Collection sds = app.getSchemas();
        if (sds.isEmpty()) {
            return;
        }
        Path zkPath = this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.SCHEMAS_DIR);
        this.configCurator.createNode(zkPath.getAbsolute());
        this.writeDir(app.getFile(ApplicationPackage.SEARCH_DEFINITIONS_DIR), zkPath, false);
        this.writeDir(app.getFile(ApplicationPackage.SCHEMAS_DIR), zkPath, false);
        for (NamedReader sd : sds) {
            this.configCurator.putData(zkPath.getAbsolute(), sd.getName(), IOUtils.readAll((Reader)sd.getReader()));
            sd.getReader().close();
        }
    }

    private void writeSomeOf(ApplicationPackage app) throws IOException {
        this.writeFile(app.getFile(Path.fromString((String)"services.xml")), this.getZooKeeperAppPath("/userapp"));
        this.writeFile(app.getFile(Path.fromString((String)"hosts.xml")), this.getZooKeeperAppPath("/userapp"));
        this.writeFile(app.getFile(Path.fromString((String)ApplicationPackage.DEPLOYMENT_FILE.getName())), this.getZooKeeperAppPath("/userapp"));
        this.writeFile(app.getFile(Path.fromString((String)ApplicationPackage.VALIDATION_OVERRIDES.getName())), this.getZooKeeperAppPath("/userapp"));
        this.writeDir(app.getFile(ApplicationPackage.RULES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.RULES_DIR), path -> path.getName().endsWith(".sr"), true);
        this.writeDir(app.getFile(ApplicationPackage.QUERY_PROFILES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.QUERY_PROFILES_DIR), xmlFilter, true);
        this.writeDir(app.getFile(ApplicationPackage.PAGE_TEMPLATES_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.PAGE_TEMPLATES_DIR), xmlFilter, true);
        this.writeDir(app.getFile(Path.fromString((String)"search/chains")), this.getZooKeeperAppPath("/userapp").append("search/chains"), xmlFilter, true);
        this.writeDir(app.getFile(Path.fromString((String)"docproc/chains")), this.getZooKeeperAppPath("/userapp").append("docproc/chains"), xmlFilter, true);
        this.writeDir(app.getFile(Path.fromString((String)"routing/tables")), this.getZooKeeperAppPath("/userapp").append("routing/tables"), xmlFilter, true);
        this.writeDir(app.getFile(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR), true);
        this.writeDir(app.getFile(ApplicationPackage.SECURITY_DIR), this.getZooKeeperAppPath("/userapp").append(ApplicationPackage.SECURITY_DIR), true);
    }

    private void writeDir(ApplicationFile file, Path zooKeeperAppPath, boolean recurse) throws IOException {
        this.writeDir(file, zooKeeperAppPath, __ -> true, recurse);
    }

    private void writeDir(ApplicationFile dir, Path path, ApplicationFile.PathFilter filenameFilter, boolean recurse) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        for (ApplicationFile file : this.listFiles(dir, filenameFilter)) {
            String name = file.getPath().getName();
            if (name.startsWith(".")) continue;
            if (file.isDirectory()) {
                this.configCurator.createNode(path.append(name).getAbsolute());
                if (!recurse) continue;
                this.writeDir(file, path.append(name), filenameFilter, recurse);
                continue;
            }
            this.writeFile(file, path);
        }
    }

    private List<ApplicationFile> listFiles(ApplicationFile dir, ApplicationFile.PathFilter filter) {
        List rawList = dir.listFiles();
        ArrayList<ApplicationFile> ret = new ArrayList<ApplicationFile>();
        if (rawList != null) {
            for (ApplicationFile f : rawList) {
                if (f.isDirectory()) {
                    ret.add(f);
                    continue;
                }
                if (!filter.accept(f.getPath())) continue;
                ret.add(f);
            }
        }
        return ret;
    }

    private void writeFile(ApplicationFile file, Path zkPath) throws IOException {
        if (!file.exists()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream inputStream = file.createInputStream();){
            inputStream.transferTo(baos);
            baos.flush();
            this.configCurator.putData(zkPath.append(file.getPath().getName()).getAbsolute(), baos.toByteArray());
        }
    }

    private void writeUserIncludeDirs(ApplicationPackage applicationPackage, List<String> userIncludeDirs) throws IOException {
        for (String userInclude : userIncludeDirs) {
            ApplicationFile dir = applicationPackage.getFile(Path.fromString((String)userInclude));
            List files = dir.listFiles();
            if (files == null || files.isEmpty()) {
                this.configCurator.createNode(this.getZooKeeperAppPath("/userapp/" + userInclude).getAbsolute());
            }
            this.writeDir(dir, this.getZooKeeperAppPath("/userapp/" + userInclude), xmlFilter, true);
        }
    }

    private void writeUserDefs(ApplicationPackage applicationPackage) {
        Map configDefs = applicationPackage.getAllExistingConfigDefs();
        for (Map.Entry entry : configDefs.entrySet()) {
            ConfigDefinitionKey key = (ConfigDefinitionKey)entry.getKey();
            String contents = ((UnparsedConfigDefinition)entry.getValue()).getUnparsedContent();
            this.writeConfigDefinition(key.getName(), key.getNamespace(), this.getZooKeeperAppPath("/userdefconfigs").getAbsolute(), contents);
            this.writeConfigDefinition(key.getName(), key.getNamespace(), this.getZooKeeperAppPath("/defconfigs").getAbsolute(), contents);
        }
        this.logger.log(Level.FINE, configDefs.size() + " user config definitions");
    }

    private void writeConfigDefinition(String name, String namespace, String path, String data) {
        this.configCurator.putDefData(namespace + "." + name, path, Utf8.toBytes((String)data));
    }

    private void write(Version vespaVersion, FileRegistry fileRegistry) {
        String exportedRegistry = PreGeneratedFileRegistry.exportRegistry((FileRegistry)fileRegistry);
        this.configCurator.putData(this.getZooKeeperAppPath("fileregistry").getAbsolute(), vespaVersion.toFullString(), exportedRegistry);
    }

    private void writeMetadata(ApplicationMetaData metaData) {
        this.configCurator.putData(this.getZooKeeperAppPath("/meta").getAbsolute(), metaData.asJsonBytes());
    }

    void cleanupZooKeeper() {
        try {
            List.of("/defconfigs", "/userdefconfigs", "/userapp").forEach(path -> this.configCurator.deleteRecurse(this.getZooKeeperAppPath((String)path).getAbsolute()));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Could not clean up in zookeeper: " + Exceptions.toMessageString((Throwable)e));
        }
    }

    private Path getZooKeeperAppPath() {
        return this.getZooKeeperAppPath(null);
    }

    private Path getZooKeeperAppPath(String trailingPath) {
        if (trailingPath == null) {
            return this.sessionPath;
        }
        return this.sessionPath.append(trailingPath);
    }

    public void write(AllocatedHosts hosts) throws IOException {
        this.configCurator.putData(this.sessionPath.append("allocatedHosts").getAbsolute(), AllocatedHostsSerializer.toJson((AllocatedHosts)hosts));
    }

    public void write(Map<Version, FileRegistry> fileRegistryMap) {
        for (Map.Entry<Version, FileRegistry> versionFileRegistryEntry : fileRegistryMap.entrySet()) {
            this.write(versionFileRegistryEntry.getKey(), versionFileRegistryEntry.getValue());
        }
    }
}

