/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.X509CertificateUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Optional;

public class EndpointCertificateRetriever {
    private final SecretStore secretStore;

    public EndpointCertificateRetriever(SecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public Optional<EndpointCertificateSecrets> readEndpointCertificateSecrets(EndpointCertificateMetadata metadata) {
        return Optional.of(this.readFromSecretStore(metadata));
    }

    private EndpointCertificateSecrets readFromSecretStore(EndpointCertificateMetadata endpointCertificateMetadata) {
        try {
            String cert = this.secretStore.getSecret(endpointCertificateMetadata.certName(), endpointCertificateMetadata.version());
            String key = this.secretStore.getSecret(endpointCertificateMetadata.keyName(), endpointCertificateMetadata.version());
            this.verifyKeyMatchesCertificate(endpointCertificateMetadata, cert, key);
            return new EndpointCertificateSecrets(cert, key);
        }
        catch (RuntimeException e) {
            return EndpointCertificateSecrets.MISSING;
        }
    }

    private void verifyKeyMatchesCertificate(EndpointCertificateMetadata endpointCertificateMetadata, String cert, String key) {
        PublicKey publicKey;
        X509Certificate x509Certificate = X509CertificateUtils.fromPem((String)cert);
        PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey((String)key);
        if (!X509CertificateUtils.privateKeyMatchesPublicKey((PrivateKey)privateKey, (PublicKey)(publicKey = x509Certificate.getPublicKey()))) {
            throw new IllegalArgumentException("Failed to retrieve endpoint secrets: Certificate and key data do not match for " + endpointCertificateMetadata);
        }
    }
}

