/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.modelfactory;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.ModelFactory;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationLockException;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.OutOfCapacityException;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.TransientException;
import com.yahoo.config.provision.Zone;
import com.yahoo.lang.SettableOptional;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.http.UnknownVespaVersionException;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.ModelResult;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.provision.ProvisionerAdapter;
import com.yahoo.vespa.config.server.provision.StaticProvisioner;
import com.yahoo.yolean.Exceptions;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class ModelsBuilder<MODELRESULT extends ModelResult> {
    private static final Logger log = Logger.getLogger(ModelsBuilder.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    protected final ConfigserverConfig configserverConfig;
    protected final boolean hosted;
    private final Zone zone;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final DeployLogger deployLogger;

    ModelsBuilder(ModelFactoryRegistry modelFactoryRegistry, ConfigserverConfig configserverConfig, Zone zone, HostProvisionerProvider hostProvisionerProvider, DeployLogger deployLogger) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.configserverConfig = configserverConfig;
        this.hosted = configserverConfig.hostedVespa();
        this.zone = zone;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.deployLogger = deployLogger;
    }

    protected Zone zone() {
        return this.zone;
    }

    protected DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public List<MODELRESULT> buildModels(ApplicationId applicationId, Optional<DockerImage> dockerImageRepository, Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, SettableOptional<AllocatedHosts> allocatedHosts, Instant now) {
        Instant start = Instant.now();
        log.log(Level.FINE, () -> "Will build models for " + applicationId);
        Set<Version> versions = this.modelFactoryRegistry.allVersions();
        Optional requestedMajorVersion = applicationPackage.getMajorVersion();
        if (requestedMajorVersion.isPresent() && (versions = this.keepUpToMajorVersion((Integer)requestedMajorVersion.get(), versions)).isEmpty()) {
            throw new UnknownVespaVersionException("No Vespa versions on or before major version " + requestedMajorVersion.get() + " are present");
        }
        List<Integer> majorVersions = versions.stream().map(Version::getMajor).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        ArrayList allApplicationModels = new ArrayList();
        boolean buildLatestModelForThisMajor = true;
        for (int i = 0; i < majorVersions.size(); ++i) {
            int majorVersion = (Integer)majorVersions.get(i);
            try {
                allApplicationModels.addAll(this.buildModelVersions(this.keepMajorVersion(majorVersion, versions), applicationId, dockerImageRepository, wantedNodeVespaVersion, applicationPackage, allocatedHosts, now, buildLatestModelForThisMajor, majorVersion));
                buildLatestModelForThisMajor = false;
                continue;
            }
            catch (ApplicationLockException | OutOfCapacityException | TransientException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (this.shouldSkipCreatingMajorVersionOnError(majorVersions, majorVersion)) {
                    log.log(Level.INFO, applicationId + ": Skipping major version " + majorVersion, e);
                    continue;
                }
                if (e instanceof IllegalArgumentException) {
                    InvalidApplicationException wrapped = new InvalidApplicationException("Error loading " + applicationId, e);
                    this.deployLogger.logApplicationPackage(Level.SEVERE, Exceptions.toMessageString((Throwable)wrapped));
                    throw wrapped;
                }
                log.log(Level.WARNING, "Unexpected error building " + applicationId, e);
                throw new InternalServerException("Unexpected error building " + applicationId, e);
            }
        }
        log.log(Level.FINE, () -> "Done building models for " + applicationId + ". Built models for versions " + allApplicationModels.stream().map(result -> result.getModel().version()).map(Version::toFullString).collect(Collectors.toSet()) + " in " + Duration.between(start, Instant.now()));
        return allApplicationModels;
    }

    private boolean shouldSkipCreatingMajorVersionOnError(List<Integer> majorVersions, Integer majorVersion) {
        if (majorVersion.equals(Collections.min(majorVersions))) {
            return false;
        }
        return majorVersion >= 8;
    }

    private List<MODELRESULT> buildModelVersions(Set<Version> versions, ApplicationId applicationId, Optional<DockerImage> wantedDockerImageRepository, Version wantedNodeVespaVersion, ApplicationPackage applicationPackage, SettableOptional<AllocatedHosts> allocatedHosts, Instant now, boolean buildLatestModelForThisMajor, int majorVersion) {
        ArrayList<MODELRESULT> builtModelVersions = new ArrayList<MODELRESULT>();
        Optional<Object> latest = Optional.empty();
        if (buildLatestModelForThisMajor) {
            latest = Optional.of(this.findLatest(versions));
            MODELRESULT latestModelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory((Version)latest.get()), applicationPackage, applicationId, wantedDockerImageRepository, wantedNodeVespaVersion, allocatedHosts.asOptional());
            allocatedHosts.set((Object)latestModelVersion.getModel().allocatedHosts());
            builtModelVersions.add(latestModelVersion);
        }
        versions = this.versionsToBuild(versions, wantedNodeVespaVersion, majorVersion, (AllocatedHosts)allocatedHosts.get());
        for (Version version : versions) {
            if (latest.isPresent() && version.equals(latest.get())) continue;
            try {
                MODELRESULT modelVersion = this.buildModelVersion(this.modelFactoryRegistry.getFactory(version), applicationPackage, applicationId, wantedDockerImageRepository, wantedNodeVespaVersion, allocatedHosts.asOptional());
                allocatedHosts.set((Object)modelVersion.getModel().allocatedHosts());
                builtModelVersions.add(modelVersion);
            }
            catch (RuntimeException e) {
                if (builtModelVersions.size() > 0 && ((ModelResult)builtModelVersions.get(0)).getModel().skipOldConfigModels(now)) {
                    log.log(Level.INFO, applicationId + ": Failed to build version " + version + ", but allow failure due to validation override \u00b4skipOldConfigModels\u00b4");
                    continue;
                }
                log.log(Level.SEVERE, applicationId + ": Failed to build version " + version);
                throw e;
            }
        }
        return builtModelVersions;
    }

    private Set<Version> versionsToBuild(Set<Version> versions, Version wantedVersion, int majorVersion, AllocatedHosts allocatedHosts) {
        versions = this.keepThoseUsedOn(allocatedHosts, versions);
        if (this.hosted && wantedVersion.getMajor() == majorVersion) {
            versions.add(wantedVersion);
        }
        return versions;
    }

    private Set<Version> keepMajorVersion(int majorVersion, Set<Version> versions) {
        return versions.stream().filter(v -> v.getMajor() == majorVersion).collect(Collectors.toSet());
    }

    private Set<Version> keepUpToMajorVersion(int majorVersion, Set<Version> versions) {
        return versions.stream().filter(v -> v.getMajor() <= majorVersion).collect(Collectors.toSet());
    }

    private Version findLatest(Set<Version> versionSet) {
        ArrayList<Version> versionList = new ArrayList<Version>(versionSet);
        Collections.sort(versionList);
        return (Version)versionList.get(versionList.size() - 1);
    }

    private Set<Version> keepThoseUsedOn(AllocatedHosts hosts, Set<Version> versions) {
        return versions.stream().filter(version -> this.isUsedOn(hosts, (Version)version)).collect(Collectors.toSet());
    }

    private boolean isUsedOn(AllocatedHosts hosts, Version version) {
        return hosts.getHosts().stream().anyMatch(host -> host.version().isPresent() && ((Version)host.version().get()).equals((Object)version));
    }

    protected abstract MODELRESULT buildModelVersion(ModelFactory var1, ApplicationPackage var2, ApplicationId var3, Optional<DockerImage> var4, Version var5, Optional<AllocatedHosts> var6);

    HostProvisioner createStaticProvisioner(ApplicationPackage applicationPackage, ApplicationId applicationId, Provisioned provisioned) {
        Optional allocatedHosts = applicationPackage.getAllocatedHosts();
        if (this.hosted && allocatedHosts.isPresent()) {
            return this.createStaticProvisionerForHosted((AllocatedHosts)allocatedHosts.get(), this.createNodeRepositoryProvisioner(applicationId, provisioned).get());
        }
        return DeployState.getDefaultModelHostProvisioner((ApplicationPackage)applicationPackage);
    }

    HostProvisioner createStaticProvisionerForHosted(AllocatedHosts allocatedHosts, HostProvisioner nodeRepositoryProvisioner) {
        return new StaticProvisioner(allocatedHosts, nodeRepositoryProvisioner);
    }

    Optional<HostProvisioner> createNodeRepositoryProvisioner(ApplicationId applicationId, Provisioned provisioned) {
        return this.hostProvisionerProvider.getHostProvisioner().map(provisioner -> new ProvisionerAdapter((Provisioner)provisioner, applicationId, provisioned));
    }
}

