/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.config.provision.TenantName;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.ConfigServerDB;
import java.io.File;

public class TenantFileSystemDirs {
    private final File serverDB;
    private final TenantName tenant;

    public TenantFileSystemDirs(ConfigServerDB configServerDB, TenantName tenant) {
        this(configServerDB.path(), tenant);
    }

    public TenantFileSystemDirs(File dir, TenantName tenant) {
        this.serverDB = dir;
        this.tenant = tenant;
        ConfigServerDB.createDirectory(this.sessionsPath());
    }

    public File sessionsPath() {
        return new File(this.serverDB, Path.fromString((String)"tenants").append(this.tenant.value()).append("sessions").getRelative());
    }

    public File getUserApplicationDir(long generation) {
        return new File(this.sessionsPath(), String.valueOf(generation));
    }

    public void delete() {
        IOUtils.recursiveDeleteDir((File)new File(this.serverDB, Path.fromString((String)"tenants").append(this.tenant.value()).getRelative()));
    }
}

