/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.metrics.ProtonMetricsAggregator;
import java.util.Map;

public class ProtonMetricsResponse
extends SlimeJsonResponse {
    public ProtonMetricsResponse(ApplicationId applicationId, Map<String, ProtonMetricsAggregator> aggregatedProtonMetrics) {
        Cursor application = this.slime.setObject();
        application.setString("applicationId", applicationId.serializedForm());
        Cursor clusters = application.setArray("clusters");
        for (Map.Entry<String, ProtonMetricsAggregator> entry : aggregatedProtonMetrics.entrySet()) {
            Cursor cluster = clusters.addObject();
            cluster.setString("clusterId", entry.getKey());
            ProtonMetricsAggregator aggregator = entry.getValue();
            Cursor metrics = cluster.setObject("metrics");
            metrics.setDouble("documentsActiveCount", aggregator.aggregateDocumentActiveCount().doubleValue());
            metrics.setDouble("documentsReadyCount", aggregator.aggregateDocumentReadyCount().doubleValue());
            metrics.setDouble("documentsTotalCount", aggregator.aggregateDocumentTotalCount().doubleValue());
            metrics.setDouble("documentDiskUsage", aggregator.aggregateDocumentDiskUsage().doubleValue());
            metrics.setDouble("resourceDiskUsageAverage", aggregator.aggregateResourceDiskUsageAverage().doubleValue());
            metrics.setDouble("resourceMemoryUsageAverage", aggregator.aggregateResourceMemoryUsageAverage().doubleValue());
        }
    }
}

