/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.restapi.SlimeJsonResponse;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.DeploymentMetricsAggregator;
import java.util.Map;

public class DeploymentMetricsResponse
extends SlimeJsonResponse {
    public DeploymentMetricsResponse(ApplicationId applicationId, Map<ClusterInfo, DeploymentMetricsAggregator> aggregatedMetrics) {
        Cursor application = this.slime.setObject();
        application.setString("applicationId", applicationId.serializedForm());
        Cursor clusters = application.setArray("clusters");
        for (Map.Entry<ClusterInfo, DeploymentMetricsAggregator> entry : aggregatedMetrics.entrySet()) {
            Cursor cluster = clusters.addObject();
            cluster.setString("clusterId", entry.getKey().getClusterId());
            cluster.setString("clusterType", entry.getKey().getClusterType());
            DeploymentMetricsAggregator aggregator = entry.getValue();
            Cursor metrics = cluster.setObject("metrics");
            aggregator.aggregateQueryRate().ifPresent(queryRate -> metrics.setDouble("queriesPerSecond", queryRate.doubleValue()));
            aggregator.aggregateFeedRate().ifPresent(feedRate -> metrics.setDouble("feedPerSecond", feedRate.doubleValue()));
            aggregator.aggregateDocumentCount().ifPresent(documentCount -> metrics.setDouble("documentCount", documentCount.doubleValue()));
            aggregator.aggregateQueryLatency().ifPresent(queryLatency -> metrics.setDouble("queryLatency", queryLatency.doubleValue()));
            aggregator.aggregateFeedLatency().ifPresent(feedLatency -> metrics.setDouble("feedLatency", feedLatency.doubleValue()));
            aggregator.feedingBlocked().ifPresent(feedingBlocked -> metrics.setDouble("feedingBlocked", (double)feedingBlocked.intValue()));
        }
    }
}

