/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;

public class TenantApplications {
    private static final Logger log = Logger.getLogger(TenantApplications.class.getName());
    private final Curator curator;
    private final Path applicationsPath;
    private static final ExecutorService pathChildrenExecutor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)TenantApplications.class.getName()));
    private final Curator.DirectoryCache directoryCache;
    private final ReloadHandler reloadHandler;
    private final TenantName tenant;

    private TenantApplications(Curator curator, Path applicationsPath, ReloadHandler reloadHandler, TenantName tenant) {
        this.curator = curator;
        this.applicationsPath = applicationsPath;
        curator.create(applicationsPath);
        this.reloadHandler = reloadHandler;
        this.tenant = tenant;
        this.directoryCache = curator.createDirectoryCache(applicationsPath.getAbsolute(), false, false, pathChildrenExecutor);
        this.directoryCache.start();
        this.directoryCache.addListener(this::childEvent);
    }

    public static TenantApplications create(Curator curator, ReloadHandler reloadHandler, TenantName tenant) {
        try {
            return new TenantApplications(curator, TenantRepository.getApplicationsPath(tenant), reloadHandler, tenant);
        }
        catch (Exception e) {
            throw new RuntimeException(TenantRepository.logPre(tenant) + "Error creating application repo", e);
        }
    }

    public List<ApplicationId> activeApplications() {
        return this.curator.getChildren(this.applicationsPath).stream().filter(this::isValid).map(ApplicationId::fromSerializedForm).filter(id -> this.activeSessionOf((ApplicationId)id).isPresent()).collect(Collectors.toUnmodifiableList());
    }

    private boolean isValid(String appNode) {
        try {
            ApplicationId.fromSerializedForm((String)appNode);
            return true;
        }
        catch (IllegalArgumentException __) {
            log.log(LogLevel.INFO, TenantRepository.logPre(this.tenant) + "Unable to parse application id from '" + appNode + "'; deleting it as it shouldn't be here.");
            try {
                this.curator.delete(this.applicationsPath.append(appNode));
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, TenantRepository.logPre(this.tenant) + "Failed to clean up stray node '" + appNode + "'!", e);
            }
            return false;
        }
    }

    public OptionalLong activeSessionOf(ApplicationId id) {
        String data = this.curator.getData(this.applicationPath(id)).map(Utf8::toString).orElseThrow(() -> new IllegalArgumentException("Unknown application '" + id + "'."));
        return data.isEmpty() ? OptionalLong.empty() : OptionalLong.of(Long.parseLong(data));
    }

    public Transaction createPutTransaction(ApplicationId applicationId, long sessionId) {
        if (this.curator.exists(this.applicationPath(applicationId))) {
            return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.setData((String)this.applicationPath(applicationId).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
        }
        return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.create((String)this.applicationPath(applicationId).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
    }

    public long requireActiveSessionOf(ApplicationId applicationId) {
        return this.activeSessionOf(applicationId).orElseThrow(() -> new IllegalArgumentException("Application '" + applicationId + "' has no active session."));
    }

    public CuratorTransaction createDeleteTransaction(ApplicationId applicationId) {
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.applicationPath(applicationId).getAbsolute()), (Curator)this.curator);
    }

    public void removeUnusedApplications() {
        this.reloadHandler.removeApplicationsExcept(Set.copyOf(this.activeApplications()));
    }

    public void close() {
        this.directoryCache.close();
    }

    private void childEvent(CuratorFramework client, PathChildrenCacheEvent event) {
        switch (event.getType()) {
            case CHILD_ADDED: {
                this.applicationAdded(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                break;
            }
            case CHILD_REMOVED: {
                this.applicationRemoved(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                break;
            }
            case CHILD_UPDATED: {
                break;
            }
        }
        this.removeUnusedApplications();
    }

    private void applicationRemoved(ApplicationId applicationId) {
        this.reloadHandler.removeApplication(applicationId);
        log.log(LogLevel.INFO, TenantRepository.logPre(applicationId) + "Application removed: " + applicationId);
    }

    private void applicationAdded(ApplicationId applicationId) {
        log.log((Level)LogLevel.DEBUG, TenantRepository.logPre(applicationId) + "Application added: " + applicationId);
    }

    private Path applicationPath(ApplicationId id) {
        return this.applicationsPath.append(id.serializedForm());
    }
}

