/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.config.server.filedistribution.ApplicationFileManager;
import com.yahoo.vespa.config.server.filedistribution.FileDBRegistry;
import com.yahoo.vespa.config.server.filedistribution.FileDirectory;
import java.io.File;

public class FileDistributionProvider {
    private final FileRegistry fileRegistry;
    private final FileDistribution fileDistribution;

    public FileDistributionProvider(File applicationDir, FileDistribution fileDistribution) {
        this(new FileDBRegistry(new ApplicationFileManager(applicationDir, new FileDirectory(fileDistribution.getFileReferencesDir()))), fileDistribution);
        FileDistributionProvider.ensureDirExists(fileDistribution.getFileReferencesDir());
    }

    FileDistributionProvider(FileRegistry fileRegistry, FileDistribution fileDistribution) {
        this.fileRegistry = fileRegistry;
        this.fileDistribution = fileDistribution;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public FileDistribution getFileDistribution() {
        return this.fileDistribution;
    }

    private static void ensureDirExists(File dir) {
        boolean success;
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new RuntimeException("Could not create directory " + dir.getPath());
        }
    }
}

