/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.TenantSecretStore;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.ProxyResponse;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class SecretStoreValidator {
    private static final String PROTOCOL = "http://";
    private static final String AWS_PARAMETER_VALIDATION_HANDLER_POSTFIX = ":4080/validate-secret-store";
    private final SecretStore secretStore;
    private final CloseableHttpClient httpClient = VespaHttpClientBuilder.create().build();

    public SecretStoreValidator(SecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public com.yahoo.container.jdisc.HttpResponse validateSecretStore(Application application, TenantSecretStore tenantSecretStore, String tenantSecretName) {
        Slime slime = this.toSlime(tenantSecretStore, tenantSecretName);
        URI uri = this.getUri(application);
        return this.postRequest(uri, slime);
    }

    private Slime toSlime(TenantSecretStore tenantSecretStore, String tenantSecretName) {
        Slime slime = new Slime();
        Cursor cursor = slime.setObject();
        cursor.setString("externalId", this.secretStore.getSecret(tenantSecretName));
        cursor.setString("awsId", tenantSecretStore.getAwsId());
        cursor.setString("name", tenantSecretStore.getName());
        cursor.setString("role", tenantSecretStore.getRole());
        return slime;
    }

    private URI getUri(Application application) {
        String hostname = application.getModel().getHosts().stream().filter(hostInfo -> hostInfo.getServices().stream().filter(service -> ContainerServiceType.CONTAINER.serviceName.equals(service.getServiceType())).count() > 0L).map(HostInfo::getHostname).findFirst().orElseThrow();
        return URI.create(PROTOCOL + hostname + AWS_PARAMETER_VALIDATION_HANDLER_POSTFIX);
    }

    private com.yahoo.container.jdisc.HttpResponse postRequest(URI uri, Slime slime) {
        HttpPost postRequest = new HttpPost(uri);
        byte[] data = (byte[])Exceptions.uncheck(() -> SlimeUtils.toJsonBytes((Slime)slime));
        ByteArrayEntity entity = new ByteArrayEntity(data);
        postRequest.setEntity((HttpEntity)entity);
        try {
            return new ProxyResponse((HttpResponse)this.httpClient.execute((HttpUriRequest)postRequest));
        }
        catch (IOException e) {
            return HttpErrorResponse.internalServerError(String.format("Failed to post request to %s: %s", uri, Exceptions.toMessageString((Throwable)e)));
        }
    }
}

