/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.maintenance.Maintainer;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.ConfigServerBootstrap;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.maintenance.ApplicationPackageMaintainer;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.ReindexingMaintainer;
import com.yahoo.vespa.config.server.maintenance.SessionsMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConfigServerMaintenance
extends AbstractComponent {
    private final List<Maintainer> maintainers = new CopyOnWriteArrayList<Maintainer>();

    @Inject
    public ConfigServerMaintenance(ConfigServerBootstrap configServerBootstrap, ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, ConfigConvergenceChecker convergence) {
        DefaultTimes defaults = new DefaultTimes(configserverConfig);
        this.maintainers.add(new TenantsMaintainer(applicationRepository, curator, flagSource, defaults.defaultInterval, Clock.systemUTC()));
        this.maintainers.add(new FileDistributionMaintainer(applicationRepository, curator, defaults.defaultInterval, flagSource));
        this.maintainers.add(new SessionsMaintainer(applicationRepository, curator, Duration.ofSeconds(30L), flagSource));
        this.maintainers.add(new ApplicationPackageMaintainer(applicationRepository, curator, Duration.ofSeconds(30L), flagSource));
        this.maintainers.add(new ReindexingMaintainer(applicationRepository, curator, flagSource, Duration.ofMinutes(3L), convergence, Clock.systemUTC()));
    }

    public void deconstruct() {
        this.maintainers.forEach(Maintainer::shutdown);
        this.maintainers.forEach(Maintainer::awaitShutdown);
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
        }
    }
}

